import { OriginalElementWidthEvents } from "../../Dream";

export enum SpriteSizeType {
  Contain = 'Contain',
  Cover = 'Cover',
  Default = 'Default'
}
// TODO SpriteSizeType 有空写下吧
export const DreamSprite: OriginalElementWidthEvents<{
  src: string | FYGE.Texture,
  width?: number,
  height?: number,
  sizeType?: SpriteSizeType
}, FYGE.Sprite> = (props) => {
  const {
    src,
    width,
    height,
    sizeType
  } = props
  let _sp: FYGE.Sprite
  if (typeof src === 'string') {
    _sp = new FYGE.Sprite()
    // 记得改一下 可能是加载过的
    FYGE.GlobalLoader.loadImage((s, image) => {
      if (s && image) {
        const texture = FYGE.Texture.fromImage(image!)
        _sp.texture = texture
      }
    }, src)
  } else {
    _sp = new FYGE.Sprite(src)
  }
  width && (_sp.width = width)
  height && (_sp.height = height)
  return _sp
}