import { OriginalElementWidthEvents } from "../../Dream";


/**
 * 切换spine 皮肤
 * @param {*} spine 
 * @param {*} skinName 
 * @returns 
 */
export function setSpineSkin(spine: FYGE.Spine, skinName: string) {
  if (!spine) return
  if (!skinName) {
    spine.setSkin(spine.skinNames[0]);
    return
  }
  if (!spine.skinNames.includes(skinName)) {
    console.error('找不到对应皮肤:', skinName)
    return
  }
  console.error('切换皮肤:', skinName)
  spine.setSkin(skinName);
}

/**
 * 设置 spine 交互动作
 * @param {*} spine 
 * @param {*} aniName 
 * @param {*} loop 
 * @param {*} cb 
 * @returns 
 */
export function setSpineAni(spine: FYGE.Spine, aniName: string, loop?: number, cb?: Function) {
  if (!spine || !aniName) {
    return
  }
  spine.animationManager.showAni(aniName, loop, () => {
    cb && cb()
  });
}


export const DreamSpine: OriginalElementWidthEvents<{
  spineData: FYGE.ISkeletonData,
  skinName?: string
  aniName?: string
}, FYGE.Spine> = ({
  spineData,
  skinName,
  aniName
}) => {
  const SpinePlayer = new FYGE.Spine(spineData)
  SpinePlayer.fps = 90
  setSpineSkin(SpinePlayer, skinName)
  setSpineAni(SpinePlayer, aniName)
  return SpinePlayer
}