import { layers } from "../../module/views/layers";

/**
 * 函数防抖，如下拉菜单
 * @param {Function} fn 
 * @param {Number} delay 
 * @returns 
 */
 export function debounce(fn: Function, delay:number=2000) {
  let timer = null;
  return function(...args) {
      let context = this;
      if(timer) clearTimeout(timer)
      timer = setTimeout(()=>{
          fn.apply(context, args)
      }, delay)
  }
}

/**
* 函数节流， 用作防连点
* @param {Function} fn 
* @param {Number} delay 
* @returns 
*/
export function throttle(fn:Function, delay: number=2000) {
  let flag = true,
    timer = null;
  return function (...args) {
    let context = this;
    if(!flag) return;
    flag = false;
    clearTimeout(timer);
    fn.apply(context, args);
    timer = setTimeout(() => {
      flag = true
    }, delay)
  }
}

/**
 * 时间格式化
 * @param {*} fmt 
 * @param {*} date 
 * @returns 
 */
 export function dateFormat(fmt, date) {
  let ret;
  date = new Date(date)
  const opt = {
    "Y+": date.getFullYear().toString(),        // 年
    "M+": (date.getMonth() + 1).toString(),     // 月
    "d+": date.getDate().toString(),            // 日
    "h+": date.getHours().toString(),           // 时
    "m+": date.getMinutes().toString(),         // 分
    "s+": date.getSeconds().toString()          // 秒
    // 有其他格式化字符需求可以继续添加，必须转化成字符串
  };
  for (let k in opt) {
    ret = new RegExp("(" + k + ")").exec(fmt);
    if (ret) {
      fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
    };
  };
  return fmt;
}

/**
 * 返回时间格式 r 秒单位
 * @param {*} fmt 
 * @param {*} r 
 * @returns 
 */
export function dateLeftFormat(fmt: string, r:number):string {
  if (r < 0) return '-1'
  let ret
  let opt = {
    "h+": Math.floor(r / 3600).toString(), //小时
    "m+": Math.floor(r % 3600 / 60).toString(), //分
    "s+": Math.floor(r % 60).toString(), //秒
  }
  for (let k in opt) {
    ret = new RegExp("(" + k + ")").exec(fmt);
    if (ret) {
      fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
    };
  };
  return fmt;
}

/**
 * 字符串填充 向前
 * @param ns 当前需要被填充的数据
 * @param len 被填充至len
 * @param s 填充的数据
 */
export function padStart(ns: number | string, len: number, s: string | number) {
  var _ns = typeof ns == 'number' ? ns + '' : ns
  var _s = typeof s == 'number' ? s + '' : s
  var _len = _ns.length
  return _len >= len ? _ns : (_s.repeat(len) + ns).slice(-len)
}

export function setCenterPos(cont: FYGE.Sprite) {
  cont.anchorTexture.set(0.5, 0.5)
  // vtodo 先这里设置一般大
  // cont.scaleX = 0.5
  // cont.scaleY = 0.5
  cont.x = layers.stageCenterX
  cont.y = layers.stageCenterY
  return cont
}

export function sleep (time:number) {
  return new Promise((resolve, reject) => setTimeout(resolve, time))
}

export function onceFnc(fn:Function, count:number = 1) {
  var cn = count
  return function() {
    if (cn-- <=0) return
    fn.apply(this, arguments)
  }
}