import { Tools } from "../Tools";
import { RES } from "../../module/RES";
import UI from "../UI";


type ProgressType = {
    width?: number,
    height?: number,
    showProgressText?: boolean,
    valueDesc?: string,
    valueColor?: string,
    type?: string,
    typeColor?: number,
    [x: string]: any
}

/**
 * 纯色进度条
 */
export class ProgressBar extends FYGE.Container {
    private upImage: FYGE.Graphics;
    private progressTxt: FYGE.TextField;
    private maxLength: number;
    private pHeight: number
    private barColor: number
    private progressCfg: ProgressType

    constructor(barColor?: number, opt?:ProgressType) {
        super()

        opt = this.progressCfg = Object.assign({}, {
            width: 377,
            height: 19,
            showProgressText: true,
            valueDesc: '',
            valueColor: '#f8c862',
            type: 'stroke',
            typeColor: 0xffffff
        }, opt)

        this.maxLength = opt.width//最大长度
        this.pHeight = opt.height
        this._value = 0;
        
        if (this.progressCfg.type == 'stroke') {
            this.addChild(new FYGE.Shape())
                .beginStroke(opt.typeColor, 2)
                .drawRoundedRect(0, 0, this.maxLength, this.pHeight, this.pHeight / 2)
                .endStroke();
        } else {
            this.addChild(new FYGE.Shape())
                .beginFill(opt.typeColor)
                .drawRoundedRect(-1, -1, this.maxLength + 2, this.pHeight + 2, this.pHeight / 2 + 1)
                .endFill();
        }

        this.barColor = barColor || 0xf8c862
        
        this.upImage = this.addChild(new FYGE.Graphics())
            .beginFill(barColor)
            .drawRoundedRect(0, 0, this.value * this.maxLength, this.pHeight, 10)
            .endFill();

        opt.showProgressText && (this.progressTxt = UI.Txt(
            this, `${this.progressCfg.valueDesc} 0%`, 22, this.progressCfg.valueColor, FYGE.TEXT_ALIGN.CENTER,
            this.maxLength, 0, 36
        ));
    }

    /**
     * 0到1的进度
     */
    private _value = 0;

    get value() {
        return this._value;
    }

    set value(v) {
        if (v < 0) v = 0;
        if (v > 1) v = 1;
        this._value = v;
        this.progressTxt && (this.progressTxt.text = this.progressCfg.valueDesc + ((v * 100) >> 0) + "%");
        var length = this._value * this.maxLength
        this.upImage.clear()
            .beginFill(this.barColor)
            .drawRoundedRect(0, 0, length, this.pHeight, 10)
            .endFill();
    }
}
