//sdk
// <script src="//yun.duiba.com.cn/db_games/libs0924/howler.min.js"></script>

// var head = document.querySelector('body');
// var script = document.createElement('script');
// script.type = 'text/javascript';
// script.src = '//yun.duiba.com.cn/db_games/libs0924/howler.min.js';
// head.appendChild(script);
// script.onload = function() {
// }

// var resPath = "https://yun.duiba.com.cn/db_games/activity/coinDozer2D/musicTry/";

// export enum SoundType {
//     bg = "hailang",
//     coin = 'oneCoinFall',
//     haixing = 'oneCoinFall'
// }


export const Soundurl = {
    bgm: '//yun.duiba.com.cn/spark/assets/9cda83ebb34225cfb5701f02eee9e190008cfffd.mp3',
    sucess: '//yun.duiba.com.cn/spark/assets/b8d82c2e432278dcc4fddfec5c6d585ac7cc5675.mp3',
    fail: '//yun.duiba.com.cn/spark/assets/aa8c3daa5c0717d58649b95216bd27e06ee714da.mp3'
}

// private sounds = {
//     fall: new window["Howl"]({ src: ["https://yun.duiba.com.cn/db_games/activity/coinDozer2D/musicTry/fall.mp3"] }),
//     oneCoinFall: new window["Howl"]({ src: ["https://yun.duiba.com.cn/db_games/activity/coinDozer2D/musicTry/oneCoinFall.mp3"] }),
//     coinsFall: new window["Howl"]({ src: ["https://yun.duiba.com.cn/db_games/activity/coinDozer2D/musicTry/pushFall.mp3"] }),
//     push: new window["Howl"]({ src: ["https://yun.duiba.com.cn/db_games/activity/coinDozer2D/musicTry/push.mp3"] })
// };

export function cusPlaySound(url: any, loop: boolean = false) {
    playSound(url, loop);
}

/**
 * 提前加载音频
 * @param type
 */
// export function preloadSound(type: SoundType) {
//     let src = resPath + type + ".mp3";
//     soundHash[src] = new window['Howl']({
//         src: src,
//         preload: true,
//     });
// }

/**
 * 根据路径记录
 */
const soundHash: { [key: string]: any } = {};
export function playSound(src: string, loop: boolean = false) {

    //console.log('测试音效',src);

    let sound;
    //循环的，且有缓存，取缓存的
    if (soundHash[src] && loop) sound = soundHash[src]
    //没有就新建
    if (!sound) sound = new window['Howl']({ src: [src], autoplay: false, loop });
    //记录下，方便停止
    soundHash[src] = sound;
    //不循环删除缓存
    if (!loop) sound.on('stop', function () { delete soundHash[src] });
    //播放
    sound.play();
    //console.log('测试是否播放音效',src);
    //返回一个，可以自行控制
    return sound;
}

export function stopSound(src: string) {
    if (soundHash[src]) soundHash[src].stop();
}

export function stopAllSound() {
    for (let key in soundHash) soundHash[key].stop();
}

export function playAllSound() {
    for (let key in soundHash) soundHash[key].play();
}


//设置隐藏属性和改变可见属性的事件的名称
let hidden: string, visibilityChange: string;
if (typeof document.hidden !== 'undefined') {
    hidden = 'hidden';
    visibilityChange = 'visibilitychange';
} else if (typeof document['msHidden'] !== 'undefined') {
    hidden = 'msHidden';
    visibilityChange = 'msvisibilitychange';
} else if (typeof document['webkitHidden'] !== 'undefined') {
    hidden = 'webkitHidden';
    visibilityChange = 'webkitvisibilitychange';
}

const handleVisibilityChange = (e) => {
    if (document.visibilityState == "visible") {
        playAllSound();
        console.log("网页显示")
    }
    else if (document.visibilityState == "hidden") {
        stopAllSound()
        console.log("网页隐藏")
    }
};

document.addEventListener(
    visibilityChange,
    handleVisibilityChange,
    false
);

window.onbeforeunload = function () {
    //发接口
}

// window.addEventListener('beforeunload', ()=>{
//     //发接口出去，

// })


// document.body['onbeforeunload'] = () => {

// }

