/**
 *
 * @param dis
 * @param zoomCenter 是否设定中心缩放，默认true，为了自行确定锚点的对象
 */
export function addClickZoom(dis: FYGE.DisplayObject, zoomCenter: boolean = true) {
    if (zoomCenter) {
        dis.anchorX = dis.width / 2;
        dis.anchorY = dis.height / 2;
    }
    dis.addEventListener("onMouseDown", _mouseEvent, dis)
        .addEventListener("onMouseUp", _mouseEvent, dis)
        .addEventListener("onMouseOut", _mouseEvent, dis);
    let s = dis;

    function _mouseEvent(e: FYGE.MouseEvent) {
        if (e.type == FYGE.MouseEvent.MOUSE_DOWN) {
            FYGE.Tween.removeTweens(s);
            FYGE.Tween.get(s).to({ scaleX: 0.9, scaleY: 0.9 }, 50);
        } else {
            FYGE.Tween.removeTweens(s);
            FYGE.Tween.get(s).to({ scaleX: 1, scaleY: 1 }, 50);
        }
    }
}
