import { RES } from "../../module/RES";
import { getLightBgTexture } from "./getLightBgTexture";

/**
 * 旋转光
 */
export class Light extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = RES.getRes("light.png");
        this.anchorTexture.set(0.5, 0.5);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            this.rotation += 1;
        }, this)
    }
}

export class RotateLight extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = getLightBgTexture();
        this.anchorTexture.set(0.5, 0.5);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            this.rotation += 1;
        }, this)
    }
}

/**
 * 背景光
 * var light = stage.addChild(new LightBg("#ff00ff"))
 */
export class LightBg extends FYGE.Shape {
    /**
     * 背景光
     * @param {string} lightColor 光条颜色，默认#fffbb0
     * @param {number} lightRadius 光条半径，默认425
     * @param {number} lightNum 光条数量，默认18
     * @param {string} bgColor 背景光晕颜色，不传和lightColor相同
     * @param {number} bgRadius 背景光晕半径，不传为光条半径-25
     */
    constructor(
        lightColor: string = "#fffbb0",
        lightRadius: number = 425,
        autoRotate: boolean = false,
        lightNum: number = 18,
        bgColor: string = lightColor,
        bgRadius: number = lightRadius - 25
    ) {
        super();
        //最大值18，否则开放每个灯光角度
        lightNum = Math.floor(Math.min(18, lightNum));
        //底座的光晕
        this.beginGradientFill([0, 0, 0, 0, 0, bgRadius], [
            [0, bgColor, 1],
            // [0.3, "#fffbb0", 0.7],
            // [0.7, "#fffbb0", 0.3],
            [1, bgColor, 0],
        ]);
        this.drawCircle(0, 0, lightRadius)
        this.endFill()
        //径向的光
        this.beginGradientFill([0, 0, 0, 0, 0, lightRadius], [
            [0, lightColor, 1],
            [1, lightColor, 0]
        ]);
        var anglePer = Math.PI / 12;
        var delta = Math.PI * 2 / lightNum;
        for (var i = 0; i < lightNum; i++) {
            this.moveTo(0, 0)
            this.arc(0, 0, lightRadius, Math.PI * 1.5 - anglePer / 2 + delta * i, Math.PI * 1.5 + anglePer / 2 + delta * i)
        }
        this.endFill();
        if (autoRotate) {
            this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
                this.rotation += 0.02
            }, this)
        }
    }
}
