/*
 * UI.ts
 * Created by 还有醋v on 2021/5/12.
 * Copyright © 2021 haiyoucuv. All rights reserved.
 */
import { RES } from "../module/RES";
import Container = FYGE.Container;
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import TextField = FYGE.TextField;
import Shape = FYGE.Shape;
import Lottie = FYGE.Lottie;

export default class UI {

    /**
     * 按钮
     * @param {FYGE.Container} parent
     * @param {string} enImg
     * @param {Function} func
     * @param that
     * @param {number} x
     * @param {number} y
     * @param {number} anchorX
     * @param {number} anchorY
     * @param {string} tImg
     * @param {string} disImg
     * @returns {FYGE.Button}
     * @constructor
     */
    static Btn(
        parent: Container,
        enImg: string,
        func: Function,
        that,
        x: number = 0, y: number = 0,
        anchorX?: number, anchorY?: number,
        tImg: string = enImg, disImg: string = enImg
    ): Button {
        const btn = new Button(RES.getRes(enImg), RES.getRes(tImg), RES.getRes(disImg));
        btn.addEventListener(MouseEvent.CLICK, func, that);
        btn.position.set(x, y);
        anchorX !== undefined && (btn.anchorX = anchorX);
        anchorY !== undefined && (btn.anchorY = anchorY);
        parent && parent.addChild(btn);
        return btn;
    }

    /**
     * 图片
     * @param {FYGE.Container} parent
     * @param {string} imageName
     * @param {number} x
     * @param {number} y
     * @returns {FYGE.Sprite}
     * @constructor
     */
    public static Sp(
        parent: Container,
        imageName: string,
        x: number = 0, y: number = 0
    ): Sprite {
        var texture = RES.getRes(imageName)
        var sprite
        if (texture) {
            sprite = new Sprite(texture);
        } else {
            sprite = Sprite.fromUrl(imageName)
        }
        sprite.position.set(x, y);
        parent && parent.addChild(sprite);
        return sprite;
    }

    /**
     * Container
     * @param {Container} parent
     * @param {number} x
     * @param {number} y
     * @returns {Container}
     * @constructor
     */
    public static Ctn(
        parent: Container,
        x: number = 0, y: number = 0
    ): Container {
        const ctn = new Container();
        ctn.position.set(x, y);
        ctn && parent.addChild(ctn);
        return ctn;
    }


    /**
     * 文本
     * @param {FYGE.Container} parent
     * @param {string} txt
     * @param {number} size
     * @param {string} color
     * @param {FYGE.TEXT_ALIGN} align
     * @param {number} textWidth
     * @param {number} x
     * @param {number} y
     * @returns {FYGE.TextField}
     */
    public static Txt(
        parent: Container,
        txt: string,
        size: number,
        color: string = "#000000",
        align: TEXT_ALIGN = TEXT_ALIGN.LEFT,
        textWidth: number = 0,
        x: number = 0,
        y: number = 0,
        bold:boolean = false
    ): TextField {
        const text = new TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.position.set(x, y);
        text.text = txt;
        text.bold = bold
        parent && parent.addChild(text);
        return text;
    }

    public static Rect(
        parent: Container,
        width: number,
        height: number,
        color: number = 0xff0000,
        radius: number = 0,
        x: number = 0,
        y: number = 0,
        alpha: number = 1,
    ): Shape {
        const shape = new Shape();
        // shape.clear();
        shape.beginFill(color);
        if (!radius) {
            shape.drawRect(0, 0, width, height);
        } else {
            shape.drawRoundedRect(0, 0, width, height, radius);
        }
        shape.endFill();
        shape.alpha = alpha;
        shape.position.set(x, y);
        parent && parent.addChild(shape);
        return shape;
    }

    public static Lottie(parent: Container, data: any, x:number=0, y:number=0) {
        const lottie = new Lottie(data);
        lottie.x = x
        lottie.y = y
        parent && parent.addChild(lottie);
        return lottie;
    }
}
