import { layers } from "../../module/views/layers";
import { CollisionData } from "../scenes/LevonoGameScene/GameTypes";

/**
 * 函数防抖，如下拉菜单
 * @param {Function} fn 
 * @param {Number} delay 
 * @returns 
 */
 export function debounce(fn: Function, delay:number=2000) {
  let timer = null;
  return function(...args) {
      let context = this;
      if(timer) clearTimeout(timer)
      timer = setTimeout(()=>{
          fn.apply(context, args)
      }, delay)
  }
}

/**
* 函数节流， 用作防连点
* @param {Function} fn 
* @param {Number} delay 
* @returns 
*/
export function throttle(fn:Function, delay: number=2000) {
  let flag = true,
    timer = null;
  return function (...args) {
    let context = this;
    if(!flag) return;
    flag = false;
    clearTimeout(timer);
    fn.apply(context, args);
    timer = setTimeout(() => {
      flag = true
    }, delay)
  }
}

/**
 * 时间格式化
 * @param {*} fmt 
 * @param {*} date 
 * @returns 
 */
 export function dateFormat(fmt, date) {
  let ret;
  date = new Date(date)
  const opt = {
    "Y+": date.getFullYear().toString(),        // 年
    "M+": (date.getMonth() + 1).toString(),     // 月
    "d+": date.getDate().toString(),            // 日
    "h+": date.getHours().toString(),           // 时
    "m+": date.getMinutes().toString(),         // 分
    "s+": date.getSeconds().toString()          // 秒
    // 有其他格式化字符需求可以继续添加，必须转化成字符串
  };
  for (let k in opt) {
    ret = new RegExp("(" + k + ")").exec(fmt);
    if (ret) {
      fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
    };
  };
  return fmt;
}

/**
 * 返回时间格式 r 秒单位
 * @param {*} fmt 
 * @param {*} r 
 * @returns 
 */
export function dateLeftFormat(fmt: string, r:number):string {
  if (r < 0) return '-1'
  let ret
  let opt = {
    "h+": Math.floor(r / 3600).toString(), //小时
    "m+": Math.floor(r % 3600 / 60).toString(), //分
    "s+": Math.floor(r % 60).toString(), //秒
  }
  for (let k in opt) {
    ret = new RegExp("(" + k + ")").exec(fmt);
    if (ret) {
      fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
    };
  };
  return fmt;
}

/**
 * 字符串填充 向前
 * @param ns 当前需要被填充的数据
 * @param len 被填充至len
 * @param s 填充的数据
 */
export function padStart(ns: number | string, len: number, s: string | number) {
  var _ns = typeof ns == 'number' ? ns + '' : ns
  var _s = typeof s == 'number' ? s + '' : s
  var _len = _ns.length
  return _len >= len ? _ns : (_s.repeat(len) + ns).slice(-len)
}

export function setCenterPos(cont: FYGE.Sprite) {
  cont.anchorTexture.set(0.5, 0.5)
  // vtodo 先这里设置一般大
  // cont.scaleX = 0.5
  // cont.scaleY = 0.5
  cont.x = layers.stageCenterX
  cont.y = layers.stageCenterY
  return cont
}

export function sleep (time:number) {
  return new Promise((resolve, reject) => setTimeout(resolve, time))
}

export function onceFnc(fn:Function, count:number = 1) {
  var cn = count
  return function() {
    if (cn-- <=0) return
    fn.apply(this, arguments)
  }
}

/**
 * 获取随机数组数据
 * @param arr 
 * @returns 
 */
export function getRandomArrItem(arr) {
  return arr[Math.floor(Math.random() * arr.length)]
}

export function spliceArrItem(arr: Array<any>, item:any) {
  const index = arr.findIndex(i => i===item)
  if (index == -1) return
  arr.splice(index, 1)
}

export function SetMouseEventNode(con: FYGE.Container) {
  con.mouseChildren = false
  con.mouseEnable = false
}

export function SetMouseEventNone<T extends FYGE.Container>(con: T):T {
  con.mouseChildren = false
  con.mouseEnable = false
  return con
}

/**
 * 获取 随机数
 * @param min 
 * @param max 
 */
export function getRandomNum(min:number, max: number) {
  return Math.random() * (max - min) + min
}

export function collisionJudge(c1: CollisionData, c2: CollisionData) {
  if (!c1 || !c2) return false
  var con1 = c1, con2 = c2
  const abs = Math.abs
  if (abs(con1.x - con2.x) < (con1.w + con2.w) / 2 && abs(con1.y - con2.y) < (con1.h + con2.h) / 2 ) {
    return true
  }
  return false
}