
export enum Soundurl {
  bgm = '//yun.duiba.com.cn/spark/assets/9cda83ebb34225cfb5701f02eee9e190008cfffd.mp3',
  sucess = '//yun.duiba.com.cn/spark/assets/b8d82c2e432278dcc4fddfec5c6d585ac7cc5675.mp3',
  fail = '//yun.duiba.com.cn/spark/assets/aa8c3daa5c0717d58649b95216bd27e06ee714da.mp3'
}
const gameSounds = {};
export const soundCtrl = {
    loadSound() {
      for (let k in Soundurl) {
        var src = Soundurl[k]
        if (src) {
          if (!gameSounds[k]) {
            gameSounds[k] = new Howl({ src: [src], autoplay: false, loop:false });
          }
        }
      }
    },
    playSound(name:Soundurl, isLoop: boolean = false) {
      console.log(name)
        let isound = gameSounds[name];
        if (!isound && Soundurl[name]) {
            isound = new Howl({
              src: [Soundurl[name]],
              autoplay: false,
              loop: isLoop
            });
            gameSounds[name] = isound;
        }
        isound && isound.play();
    },
    stopSound(name:Soundurl) {
        let isound = gameSounds[name];
        isound && isound.stop();
    }
}
