import { RES } from "../../../module/RES"
import { Tools } from "../../Tools";
import UI from "../../UI";
import { CollisionData } from "./GameTypes"

interface CurrProportion {
  mileage: number,
  proportion: Array<number>,
  speed: number
}

type ProportionList = Array<CurrProportion>

type GameDiffConfigType = {
  initGameDiff: Function,
  getCurrGameDiff: Function
}

export const GameDiffConfig: GameDiffConfigType = (function() {
  let proportionList:ProportionList = []
  let _i = null // 暂作比较
  let _lcurr = null 
  return {
    initGameDiff(pl: ProportionList) {
      proportionList = pl || [
        {
          mileage: 100,
          proportion: [0.5,0.7,1],
          speed: 300,
        },
        {
          mileage: 120,
          proportion: [0.5,0.7,1],
          speed: 530,
        },
        {
          mileage:2200,
          proportion: [0.1,0.7,1],
          speed: 500,
        }
      ]
    },
    /**
     * 获取当前 概率
     * @param m 
     */
    getCurrGameDiff(m: number, cb?: Function):CurrProportion {
      const currIndex = proportionList.findIndex(i => m < i.mileage)
      if (currIndex != _i) {
        const curr = _lcurr = currIndex == -1 ? proportionList.slice(-1)[0] : proportionList[currIndex]
        _i = currIndex
        cb(curr)
        return curr
      } else {
        return _lcurr
      }
      // console.log(currIndex, proportionList, proportionList.slice(currIndex, 1))
      const curr = currIndex == -1 ? proportionList.slice(-1)[0] : proportionList[currIndex]
      return curr
    }
  }
})()

/**
 * obstacle 障碍物 unObstacle 非障碍物
 */
export type GameEleType = 'obstacle' | 'unObstacle'

interface GameEleInfer {
  _type: GameEleType,
  _res: string,
  speed: number, // 当前速度
  getMaterialCollisionObj: () => CollisionData, // 获取碰撞
  setPostion: (x: number, y: number) => void // 配置坐标
  onCollision: () => void
}

interface GameEleOfGamerPropsInfer {
  isSpeedUp: boolean
}

export class GameEleOfGamer extends FYGE.Container implements GameEleInfer {
  speed: number
  _type: GameEleType = 'obstacle'
  _res: string;
  _isSpeedUp: boolean = false
  offsetX: number = 120
  offsetY: number = 230
  collisionProportionOfY: number = 0.2
  rWidth: number = 260
  rHeight: number = 460
  pxl: Array<number> = [0, 360, 750]
  _pxlIndex: number = 1
  GamerMovieClip: FYGE.MovieClip
  protectAtomphere: FYGE.Sprite
  status: number = 0 // 0 正常 1 闪烁
  isStart: boolean = false

  get isSpeedUp() {
    return this._isSpeedUp
  }

  set isSpeedUp(n) {
    if (!n) {
      this.protectAtomphere && (this.protectAtomphere.visible = false);
      (this.GamerMovieClip || (this.GamerMovieClip = this.GamerMovieClip = UI.MoiveClip(this, 'normalGamer.svga', -40))).init(RES.getRes('normalGamer.svga'))
    } else {
      (this.protectAtomphere || (this.protectAtomphere = UI.Sp(this, 'gamer-protect.png', -210, -150))).visible = true;
      FYGE.Tween.get(this.protectAtomphere, {
        loop: true
      })
        .to({alpha: 0.6}, 600)
        .to({alpha: 1}, 600)
      this.GamerMovieClip.init(RES.getRes('speedUpGamer.svga'))
    }
    this._isSpeedUp = n
  }
  
  get pxlIndex():number  {
    return this._pxlIndex
  }

  set pxlIndex(n) {
    if (this.pxl[n] === undefined) {
      return
    }
    FYGE.Tween.removeTweens(this)
    const tr = Math.abs(this.pxl[n] - this.fx) / 360 * 200
    FYGE.Tween.get(this)
      .to({
        fx: this.pxl[n]
      }, tr)
    this._pxlIndex = n
  }

  get fx() {
    return this.x + this.offsetX
  }

  set fx(n) {
    this.x = n - this.offsetX
  }

  get fy() {
    return this.y + this.offsetY
  }

  set fy(n) {
    this.y = n - this.offsetY
  }

  constructor(props:GameEleOfGamerPropsInfer) {
    super()
    this.isSpeedUp = props.isSpeedUp
    this.initUi()
    this.stop()
  }

  start() {
    this.GamerMovieClip?.play()
  }

  stop() {
    this.GamerMovieClip?.stop()
  }

  reset() {
    this.pxlIndex = 1
    this.fy = 1030
  }

  /**
   * 设置左右移动， +1 或者 -1
   * @param n 
   */
  setGamerPosIndex(n: number) {
    this.pxlIndex += n
    console.log('test:', this.pxlIndex, n)
  }

  initUi() {
    // 240 1000
    Tools.PAGE.debug && UI.Rect(this, 260, this.rHeight * this.collisionProportionOfY, 0xcccccc, 20, 0, this.rHeight * (1-this.collisionProportionOfY)-50, 0.7)
    this.reset()
  }

  setPostion(x: number, y: number=1030) {
    this.fx = x
    this.fy = y
    // this.position.set(x - this.offsetX, y - this.offsetY)
  }

  getMaterialCollisionObj(): CollisionData {
    return {
      x: this.x,
      y: this.y + this.rHeight * (1 - this.collisionProportionOfY)-50,
      w: this.rWidth,
      h: this.rHeight * this.collisionProportionOfY
    }
  }

  onBulingBuling() {
    if (this.status) return
    this.status = 1
    FYGE.Tween.get(this, {
      loop: true
    })
      .to({alpha: 0.6}, 200)
      .to({alpha: 1}, 200)
    
    setTimeout(() => {
      FYGE.Tween.removeTweens(this)
      this.alpha = 1
      this.status = 0
    }, 2000)
  }

  onCollision() {}
}

export class GameEleOfPowerBall extends FYGE.Container implements GameEleInfer {
  speed: number = 0
  _type: GameEleType = 'unObstacle'
  _res: string
  offsetX: number = 130
  offsetY: number = 130
  collisionProportionOfY: number = 0.4
  rHeight: number = 260
  rWidth: number = 260
  /**
   * 基本比较是200*200的大小
   * @param mv 
   * @param whInfo 
   */
  constructor(mv: string) {
    super()
    this.addChild(new FYGE.Sprite(RES.getRes('powerBallShadow.png')))
      .position.set(90, 260)

    this.addChild(new FYGE.MovieClip(RES.getRes(mv)))
    this._res = mv
    this.anchor.set(this.offsetX, this.offsetY)
    this.reset()
    const t = this.getMaterialCollisionObj()
    Tools.PAGE.debug && UI.Rect(this, t.w, t.h, 0xcccccc, 20, 0, this.rHeight * (1-this.collisionProportionOfY), 0.7)
  }

  setPostion(x: number, y: number=0) {
    this.position.set(x - this.offsetX, y - this.offsetY)
  }

  reset() {
    this.speed = 0
    this.scale.set(0)
    this.visible = true
  }

  onCollision() {

  }

  getMaterialCollisionObj(): CollisionData {
    return {
      x: this.x,
      y: this.y + this.rHeight * (1 - this.collisionProportionOfY),
      w: this.rWidth,
      h: this.rHeight * this.collisionProportionOfY
    }
  }
}

export class GameEleOfWater extends FYGE.Sprite implements GameEleInfer {
  speed: number = 0
  _type: GameEleType = 'obstacle'
  _res: string
  collisionProportionOfY: number = 0.5

  constructor(res: string) {
    super(RES.getRes(res))
    this._res = res
    this.anchorTexture.set(0.5, 0.5)
    const t = this.getMaterialCollisionObj()
    this.reset()
    Tools.PAGE.debug && UI.Rect(this, t.w, t.h, 0xcccccc, 20, 0 - this.width / 2, this.height * (1-this.collisionProportionOfY) - this.height / 2, 0.7)
  }

  setPostion(x: number, y: number=0) {
    this.position.set(x, y)
  }

  getMaterialCollisionObj():CollisionData {
    return {
      x: this.x - this.width / 2,
      y: this.y - this.height / 2 + this.height * (1 - this.collisionProportionOfY),
      w: this.width,
      h: this.height * this.collisionProportionOfY
    }
  }

  reset() {
    this.speed = 0
    this.scale.set(0)
    this.visible = true
  }

  onCollision() {
    
  }

}

export class GameEleOfBucket extends FYGE.Sprite implements GameEleInfer {
  speed: number;
  _type: GameEleType = 'obstacle'
  _res: string
  collisionProportionOfY: number = 0.4

  constructor(res: string) {
    super(RES.getRes(res))
    this._res = res
    this.anchorTexture.set(0.5, 0.5)
    const t = this.getMaterialCollisionObj()
    this.reset()
    Tools.PAGE.debug && UI.Rect(this, t.w, t.h, 0xcccccc, 20, 0- this.width / 2, this.height * (1-this.collisionProportionOfY) - this.height / 2, 0.7)
    
  }

  reset() {
    this.speed = 0
    this.scale.set(0)
    this.visible = true
  }

  setPostion(x: number, y: number=0) {
    this.position.set(x, y)
  }

  onCollision() {
    
  }

  getMaterialCollisionObj():CollisionData {
    return {
      x: this.x - this.width / 2,
      y: this.y - this.height / 2 + this.height * (1 - this.collisionProportionOfY),
      w: this.width,
      h: this.height * this.collisionProportionOfY
    }
  };

}