import { changeScene } from './../../module/ctrls/index';
import { RES } from "../../module/RES";
import { Panel } from "../../module/views/Panel";
import UI from "../UI";
import { LOG_TYPE, sendLog } from '../WebNet';

interface GameOverPanelInfer {
  "score": number,
  "maxScore": number,
  "rewardCredits": number,
  onGameRestart?: Function
}

export class GameOverPanel extends Panel {
  closeBtn: FYGE.Button;
  get groupNames(): string[] {
    return ['GameOverPanel']    
  }

  onGameRestart: Function
  constructor(data: GameOverPanelInfer) {
    super()
    this.onGameRestart = data.onGameRestart
  }

  RoleContainer: FYGE.Container
  initUi(): void {
    sendLog(LOG_TYPE.EXPOSURE, 76)
    sendLog(LOG_TYPE.EXPOSURE, 75)
    const RoleContainer = this.RoleContainer = UI.Ctn(this, (750 - 616) / 2, (1624 -600) / 2)
    UI.Sp(RoleContainer, 'atomphere.png', -50, -300)
    RoleContainer.addChild(new FYGE.MovieClip(RES.getRes('获奖弹窗.svga')))
      .position.set(-70, -330)
    UI.Sp(RoleContainer, 'GameOverPanelBack')

    // this.closeBtn = UI.Btn(RoleContainer, 'comCloseBtn.png')
    // this.closeBtn.position.set( 560, -100)
    
    UI.Btn(RoleContainer, 'cancel-btn.png', function() {
      sendLog(LOG_TYPE.CLICK, 75)
      this.hidePanel()
    }, this, 40, 430)

    UI.Btn(RoleContainer, 'confirm-btn.png', async function() {
      sendLog(LOG_TYPE.CLICK, 76)
      this.onGameRestart()
      this.hidePanel()
      // changeScene(IndexScene)
    }, this, 320, 430)

  }

  start(data?: GameOverPanelInfer): void {
    UI.Txt(this.RoleContainer, `获得${data.rewardCredits}活力值`, 36, '#914533', FYGE.TEXT_ALIGN.CENTER, 616, 0, 145)
    UI.Txt(this.RoleContainer, `${data.score}`, 48,'#e34539', FYGE.TEXT_ALIGN.CENTER, 305, 0, 310, true)
    UI.Txt(this.RoleContainer, `${data.maxScore}`, 48,'#e34539', FYGE.TEXT_ALIGN.CENTER, 385, 265, 310, true)
  }
}