type direct =  'right' | 'bottom' | 'top'

/**
 * 传入文案和进度条图片
 * 进度条图片位移，固定遮罩
 * 貌似这样就不需要继承显示类了
 */
export class ProgressBarS {
    private upImage: FYGE.Sprite;
    private progressTxt: FYGE.TextField;
    private maxLength: number;
    private oriX: number
    private oriY: number
    private dire: direct

    constructor(upImage: FYGE.Sprite, txt?: FYGE.TextField, dire?: direct) {
        this.dire = dire
        this.maxLength = dire === 'right' ? upImage.width : upImage.height;//最大长度，直接取图片宽度

        this.upImage = upImage;

        this.progressTxt = txt;


        this.oriX = upImage.x;
        this.oriY = upImage.y
        var delta = 0
        //传入的也可能是帧动画，这样原点就有问题了
        if (upImage instanceof FYGE.FrameAni) delta = 0.5
        //给图片加个矩形遮罩
        this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
            .beginFill(0xf8c862)
            .drawRoundedRect(
                upImage.x - upImage.width * delta,
                upImage.y - upImage.height * delta,
                upImage.width,
                upImage.height,
                111
            )
            .endFill();


        this.value = 0;
    }

    /**
     * 0到1的进度
     */
    private _value = 0;

    get value() {
        return this._value;
    }

    set value(v) {
        if (v < 0) v = 0;
        if (v > 1) v = 1;
        this._value = v;
        if (this.progressTxt) this.progressTxt.text = ((v * 100) >> 0) + "%";
        let xory = this.dire === 'right' ? 'x' : 'y'
        let o = this.dire === 'right' ? this.oriX : this.oriY
        if (this.dire === 'top') {
            this.upImage[xory] = o + (1 - this._value) * this.maxLength
        } else {
            this.upImage[xory] = o - (1 - this._value) * this.maxLength
        }
        
    }
}
