
/**
 * 回收池
 */
export class GPool {
    private static pool = {};

    /**
     * 取出
     * @param name 
     */
    public static takeOut<T>(name: string): T {
        if (this.pool[name] && this.pool[name].length) {
            // console.log('从对象池中qu');
            return this.pool[name].shift();
        }
        return null;
    }

    /**
     * 放入对象池
     * @param name 
     * @param poolItem 
     */
    public static takeIn(name: string, poolItem: any) {
        // console.log('从对象池中存');
        (this.pool[name] || ( this.pool[name] = [] )).push(poolItem)
    }

    /**
     * 回收
     * @param name 
     * @param obj 
     */
    public static recover(name: string, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    }

    public static clear() {
        this.pool = Object.create(null)
    }
}