
/**
 * 装饰方法 执行完Promise 之后 才可以第二次执行
 * @param target 
 * @param property 
 * @param descriptor 
 */
 export function PromiseAwait(target: any, property: string, descriptor: PropertyDescriptor) {
  const func: Function = descriptor.value
  let waitPromise: Promise<any> | null = null
  let waitPromiseResolve: (value: unknown) => void
  descriptor.value = async function(...args:any[]) {
    if (waitPromise) return waitPromise
    waitPromise = new Promise(resolve => {
      waitPromiseResolve = resolve
    })
    const res = await func.apply(this, args)
    waitPromiseResolve(res)
    waitPromise = null
    return res
  }
}

/**
 * PromiseAwait 闭包版本
 * @param func 
 * @returns 
 */
export function promiseAwaitFunc(func: Function) {
  let waitPromise: Promise<any> | null = null
  let waitPromiseResolve: (value: unknown) => void
  return async function(...args: any[]) {
    if (waitPromise) return waitPromise
    waitPromise = new Promise(resolve => {
      waitPromiseResolve = resolve
    })
    const res = await func.apply(this, args)
    waitPromiseResolve(res)
    waitPromise = null
    return res
  }
}

export function CountDownFac(totalCount) {
  let count = totalCount;
  let intervalId = null
  return {
    start(step, cb) {
      intervalId = setInterval(() => {
        if (count == 0) {
          cb && cb()
          this.end()
          return
        }
        count--
        step && step(count)
      }, 1000)
    },
    end() {
      intervalId && clearInterval(intervalId)
    }
  }
}

export class CountDownWithTweenCls {
  onChangeCb: (t: number) => void
  onEnd: () => void
  countDownTotalTime: number
  countDownTweenObj: {t: number}

  constructor(time: number, onChangeCb: (t: number) => void, onEnd: () => void) {
    this.onChangeCb = onChangeCb
    this.onEnd = onEnd
    this.countDownTotalTime = time
  }

  start() {
    this.countDownTweenObj && FYGE.Tween.removeTweens(this.countDownTweenObj)
    this.countDownTweenObj = {
      t: this.countDownTotalTime
    }
    FYGE.Tween.get(this.countDownTweenObj,
        {
          onChange: () => {
            this.onChangeCb(this.countDownTweenObj.t)
          }
        }
      )
      .to({
        t: 0
      }, this.countDownTotalTime)
      .call(() => {
        this.onEnd()
      })
  }

  stop()  {
    if (!this.countDownTweenObj) return
    FYGE.Tween.pauseTweens(this.countDownTweenObj)
  }

  resume() {
    if (!this.countDownTweenObj) return
    FYGE.Tween.resumeTweens(this.countDownTweenObj)
  }
}

export function CountDownWithTween(time: number, onChangeCb: (t: number) => void, onEnd: () => void) {
  const countDownTotalTime = time
  let countDownTweenObj: {t: number}
  return {
    start: () => {
      countDownTweenObj && FYGE.Tween.removeTweens(countDownTweenObj)
      countDownTweenObj = {
        t: countDownTotalTime
      }
      FYGE.Tween.get(countDownTweenObj,
          {
            onChange() {
              onChangeCb(countDownTweenObj.t)
            }
          }
        )
        .to({
          t: 0
        }, countDownTotalTime)
        .call(() => {
          onEnd()
        })
    },
    stop: () => {
      if (!countDownTweenObj) return
      FYGE.Tween.pauseTweens(countDownTweenObj)
    },
    resume() {
      if (!countDownTweenObj) return
      FYGE.Tween.resumeTweens(countDownTweenObj)
    }
  }

}