import { changeScene } from './../../../module/ctrls/index';
import { RES } from "../../../module/RES";
import { Scene } from "../../../module/views/Scene";
import { ProgressBarS } from "../../common/ProgressBarS";
import UI from "../../tools/UI";
import { IndexScene } from '../IndexScene/IndexScene';
import { sendWebNet, WebNetName } from '../../tools/WebNet';

export class LoadingScene extends Scene {

  ProgressFactory: ProgressBarS

  get groupNames(): string[] {
    return ['loading']
  }

  initUi(): void {
    UI.Sp(this, 'loadBack.jpg')

    const ProgressCont = UI.Ctn(this)
    UI.Sp(ProgressCont, 'progress-back.png')
    const tracker = UI.Sp(ProgressCont, 'progress-track.png')
    UI.Sp(ProgressCont, 'progress-icon.png', -10, -20)

    this.ProgressFactory = new ProgressBarS(tracker)
    

    ProgressCont.position.set(220, 800)
  }

  async start(data?: any) {
    super.start(data)

    this.setProgressValue(0.3)
    // 加载游戏资源 
		await RES.loadGroup('GameScene')

    this.setProgressValue(0.5)

    // 加载首页资源 
		await RES.loadGroup('IndexScene')

    // 走下接口，这里有点小问题， 接口报错了， 还让进去吗
    await sendWebNet(WebNetName.index, {}, undefined, true)

    await sendWebNet(WebNetName.projectRule)

    this.setProgressValue(1)
  }

  setProgressValue(value: number) {
    FYGE.Tween.removeTweens(this.ProgressFactory)
    FYGE.Tween.get(this.ProgressFactory)
      .to({
        value
      }, 600)
      .call(() => {
        if (value === 1) {
          changeScene(IndexScene)
        }
      })
  }
}