import { ParkourGameConfig, ParkourGameEleType, ParkourGameEvents } from './ParkourGameConfig';
import { Scene } from "../../module/views/Scene";
import UI from "../tools/UI";
import { ConveyorBelt, ConveyorBeltItem } from "./comp/ConveyorBelt";
import { GDispatcher } from '../Game';
import { CollisionDetection, RectPhysicsCont, WithCollisionDetection } from './CollisionComposite';
import { BalalaScene } from './BalalaScene';
import { LOG_TYPE, sendLog } from '../tools/WebNet';

/**
 * 解个一元一次方程式咯
 * @param x1 
 * @param y1 
 * @param x2 
 * @param y2 
 * @returns 
 */
function SolveUnivariateEquation(x1: number, y1: number, x2: number, y2: number) {
  const k = (y2 - y1) / (x2 - x1)
  const b = y1 - k * x1
  return { k, b }
}

export class ParkourScene extends Scene {
  get groupNames(): string[] {
    return ['GameScene']
  }

  conBeltList: ConveyorBelt[] = []
  NewContIns: ConveyorBeltItem

  _GamerIndex: number

  isPaused: boolean = true

  get GamerIndex() {
    return this._GamerIndex
  }

  set GamerIndex(v: number) {
    if (this._GamerIndex === v) return
    const data = ParkourGameConfig.ConveyorBeltList[v]
    if (data) {
      const {k, b} = (data.k && data) || SolveUnivariateEquation(data.startPos.x, data.startPos.y, data.endPos.x, data.endPos.y)
      data['k'] = k
      data['b'] = b
      this._GamerIndex = v

      const y = ParkourGameConfig.CommonConfig.GamerAxisY
      const x = !Number.isFinite(k) ? data.startPos.x : (y - b) / k

      this.NewContIns.fy = y
      // 简单的做一个 tween 动画吧
      FYGE.Tween.removeTweens(this.NewContIns)
      FYGE.Tween.get(this.NewContIns)
        .to({
          fx: x
        }, 300, FYGE.Ease.quadInOut)

      // this.NewContIns.setPosition(x, y)
    }
  }

  initUi() {
    sendLog(LOG_TYPE.EXPOSURE, 3)

    this.addChild(new BalalaScene())

    // 生成传送带
    ParkourGameConfig.ConveyorBeltList.forEach((item, index) => {
      this.conBeltList.push(this.addChild(new ConveyorBelt({
        ParkourGameEleList: ParkourGameConfig.ParkourGameEleList,
        ...item,
      }, this.onJudgeNextObstacle)))
    })

    const NewContIns = this.NewContIns = this.addChild(new ConveyorBeltItem(ParkourGameConfig.ParkourGamer))
    NewContIns.setPosition(0, 0)

    this.onResetUi()
  }

  onResetUi() {
    this.isPaused = false

    this.GamerIndex = ParkourGameConfig.CommonConfig.GamerIndex
  }

  onGamePause() {
    this.isPaused = true
  }


  /**
   * 判断下一个障碍物 是否可以出，防止必死的情况
   * @param data 
   * @returns 
   */
  onJudgeNextObstacle = (data: ParkourGameEleType) => {
    // TODO: 判断下一个障碍物 是否可以出，防止必死的情况
    // 就比如下面就比较简单 下一个 item.uniqueKey 为 uniqueKey1 就回去
    // 判断全部的传送带是否有 uniqueKey1 并且距离刷新点小于一定距离
    // 这样就能 防止必死的情况'
    const safeNum = ParkourGameConfig.CommonConfig.safeDistance
    if (safeNum) {
      if (data.uniqueKey === 'shit') {
        return this.conBeltList.filter(item => {
          return item.children.some((child: ConveyorBeltItem) => {
            return child.y < safeNum && child.uniqueKey === 'shit'
          })
        }).length < 2
      }
      return true
    }
    return true
  }

  initEvents(): void {
    this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this)

    GDispatcher.addEventListener(ParkourGameEvents.GAME_RESTART, this.onResetUi, this)

    GDispatcher.addEventListener(ParkourGameEvents.GAME_PAUSE, this.onGamePause, this)

    this.stage.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.onGameDetermineMouseDown, this)

    // 测试碰撞检测用的
    // this.stage.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.onMouseDown, this)
  }

  removeEvents(): void {
    this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this)

    GDispatcher.removeEventListener(ParkourGameEvents.GAME_RESTART, this.onResetUi, this)

    GDispatcher.removeEventListener(ParkourGameEvents.GAME_PAUSE, this.onGamePause, this)

    this.stage.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.onGameDetermineMouseDown, this)
  }

  /**
   * 游戏左右滑动的 检测
   * @param e 
   */
  onGameDetermineMouseDown(e: FYGE.MouseEvent) {
    if (this.isPaused) return
    const startPos = {
      x: e.stageX,
      y: e.stageY
    }
    this.once(FYGE.MouseEvent.MOUSE_UP, () => {
      const offsetX = e.stageX - startPos.x
      if (Math.abs(offsetX) > ParkourGameConfig.CommonConfig.DetermineXAxis) {
        this.GamerIndex += offsetX > 0 ? 1 : -1
      }
    })
  }

  /**
   * 游戏帧事件
   */
  onEnterFrame() {
    this.conBeltList.forEach(it => {
      if (it.isMoving) {
        for (let i = it.conveyorItemList.length - 1; i >= 0; i--) {
          const item: ConveyorBeltItem = it.conveyorItemList[i] as ConveyorBeltItem
          // @ts-expect-error
          if (CollisionDetection.onCollsionJudge(item.PythicCont, this.NewContIns.PythicCont)) {
            it.onTakeIntoPool(item, false)
          }

          // 为了视觉上更加好吧
          if (item.y >= ParkourGameConfig.CommonConfig.GamerAxisY) {
            this.addChild(item)
          }
        }
      }
    })
  }

  /**
   * 测试用的
   * @param e 
   */
  onMouseDown(e: FYGE.MouseEvent) {
    const startPos = {
      x: e.stageX,
      y: e.stageY
    }

    function move(e: FYGE.MouseEvent) {
      const endPos = {
        x: e.stageX,
        y: e.stageY
      }
      this.NewContIns.position.set(endPos.x, endPos.y)
    }

    this.stage.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, move, this)
    this.stage.once(FYGE.MouseEvent.MOUSE_UP, () => {
      this.stage.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, move, this)
    })
  }
}