import { ExtraEvents } from './ExtraConfig';
import { GDispatcher } from "../Game";
import UI from "../tools/UI";
import { PromiseAwait, promiseAwaitFunc } from './utils';

export type UniqueKeyType = 'coins' | 'shit' | 'protect'

/**
 * 传送带 item 的 类型申明
 */
export type ConveyorItemConstrutType = {
  Container: `${string}.jpg` | `${string}.png` | `${string}.svga` | (new (...args: any[]) => FYGE.Container)
  anchorX?: number,
  anchorY?: number,
  collisionConfig?: {
    type: 'rect' | 'circle', // 其实 这里只写了 rect
    x: number,
    y: number,
    w: number,
    h: number
  },
  uniqueKey?: UniqueKeyType, // 唯一标志
}

type ParkourGamerType = ConveyorItemConstrutType

export type ParkourGameEleType = {
  ProbabilityPort: number, // 概率
} & ConveyorItemConstrutType

type PosPoint = {
  x: number,
  y: number
}

export type ConveyorBeltType = {
  startPos: PosPoint,
  endPos: PosPoint,
  startTyl?: number, // 每个间距
  ParkourGameEleList?: ParkourGameEleType[],
  k?: number,
  b?: number,
  scaleEndProportion?: number, // 缩放结束比例
  common?: {
    
  }
}

interface ParkourGameConfigInfer {
  ParkourGamer: ParkourGamerType,
  ConveyorBeltList: ConveyorBeltType[],
  ParkourGameEleList: ParkourGameEleType[],
  CommonConfig: { // 通用配置
    speed: number // 速度
    CollisionDebug: boolean // 碰撞检测 debug
    GamerAxisY: number // 玩家轴Y
    GamerIndex: number // 默认玩家索引 在哪条 道上
    DetermineXAxis: number // 玩家 x 方向判定移动距离
    safeDistance?: number // 安全距离
  } 
}

/**
 * 游戏事件
 */
export enum ParkourGameEvents {
  CONVEYOR_MOVE_Y = "conveyor_movey",
  CONVEYOR_INIT_OBSTACK = "conveyor_init_obstack",
  GAME_RESUME = 'GAME_RESUME', // 游戏resume
  GAME_RESTART = 'GAME_RESTART', // 游戏重新开始
  // GAME_OVER = 'GAME_OVER', // 游戏完成
  GAME_PAUSE ='GAME_PAUSE', // 游戏暂停

  GAME_RESET = 'GAME_RESET', // 游戏重置

  GAME_RESET_PARKOURELE = 'GAME_RESET_PARKOURELE', // 重新设置 游戏元素配置
  GAME_SPEEDUP = 'GAME_SPEEDUP', // 游戏加速

  GAME_COLLESION ='GAME_COLLESION', // 游戏碰撞
}

/**
 * 跑酷游戏的简单配置项
 * 注意 png 或者 jpg的 不用设置 anchorX 和 anchorY
 */
export const ParkourGameConfig: ParkourGameConfigInfer = {
  ParkourGamer: {
    Container: class extends FYGE.Container {
      constructor() {
        super();

        this.onInitUi()

        this.initEvents()
      }

      onInitUi() {
        UI.Sp(this, 'fkingCar.png')
      }

      shieldCont: FYGE.Container
      onGetProtect = () => {
        if (!this.shieldCont) {
          this.shieldCont = UI.Sp(this, '护盾.png', -130, -100)

          FYGE.Tween.get(this.shieldCont, {
            loop: true
          }).to({
            alpha: 0.5
          }, 300)
            .to({alpha: 1}, 300)
        }
        this.shieldCont.visible = true
      }

      onRemoveProtect() {
        this.shieldCont && (this.shieldCont.visible = false)
      }

      initEvents() {
        GDispatcher.addEventListener(ExtraEvents.GET_PROTECT, this.onGetProtect, this)

        GDispatcher.addEventListener(ExtraEvents.REMOVE_PROTECT, this.onRemoveProtect, this)
      }

      removeEvents() {
        GDispatcher.removeEventListener(ExtraEvents.GET_PROTECT, this.onGetProtect, this)

        GDispatcher.removeEventListener(ExtraEvents.REMOVE_PROTECT, this.onRemoveProtect, this)
      }

      destroy(): void {
        super.destroy()
        this.removeEvents()
      }
    },

    collisionConfig: {
      type: 'rect',
      x: 0,
      y: 0,
      w: 140,
      h: 180
    },
    anchorX: 70,
    anchorY: 35
  },
  ConveyorBeltList: [
    {
      startPos: {
        x: 374,
        y: 200,
      },
      endPos: {
        x: 0,
        y: 1624
      },
      startTyl: 400,
      scaleEndProportion: 0.8
    },
    {
      startPos: {
        x: 378,
        y: 200,
      },
      endPos: {
        x: 378,
        y: 1624
      },
      startTyl: 400,
      scaleEndProportion: 0.8
    },
    {
      startPos: {
        x: 384,
        y: 200,
      },
      endPos: {
        x: 750,
        y: 1624
      },
      startTyl: 300,
      scaleEndProportion: 0.8
    }
  ],
  ParkourGameEleList: [
    {
      uniqueKey: 'coins',
      Container: 'obstack1.png',
      ProbabilityPort: 10,
      collisionConfig: {
        type: 'rect',
        x: -50,
        y: 0,
        w: 100,
        h: 50
      }
    },
    {
      uniqueKey: 'shit', // 这个是障碍物
      Container: 'obstack2.png',
      ProbabilityPort: 1000,
      // anchorX: 130,
      // anchorY: 130,
      collisionConfig: {
        type: 'rect',
        x: -50,
        y: 0,
        w: 100,
        h: 50
      }
    },
    // {
    //   uniqueKey: 'protect',
    //   Container: 'obstack3.png',
    //   ProbabilityPort: 0,
    //   // anchorX: 100,
    //   // anchorY: 100,
    //   collisionConfig: {
    //     type: 'rect',
    //     x: -50,
    //     y: 0,
    //     w: 100,
    //     h: 50
    //   }
    // }
  ],
  CommonConfig: {
    speed: 300, //  速度 可以通过GAME_SPEEDUP 修改
    CollisionDebug: true, // 碰撞检测 debug
    GamerAxisY: 1100, // 玩家轴Y
    GamerIndex: 1, // 当前玩家索引 在哪条道
    DetermineXAxis: 50, // 左右滑动判定距离
    safeDistance: 500 // 判断的安全距离
  }
}