import { changeScene, showPanel } from "../../../module/ctrls";
import { RES } from "../../../module/RES";
import { Scene } from "../../../module/views/Scene";
import { RuleModal } from "../../panels/RulePanel";
import { Tools } from "../../tools/Tools";
import UI from "../../tools/UI";
import { getWebData, LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../../tools/WebNet";
import { ParkourScene } from "../ParkourGameScene";
import { PromiseAwait } from "../utils";

export class IndexScene extends Scene {
  get groupNames(): string[] {
    return ['IndexScene']
  }

  ruleBtn: FYGE.Sprite
  awardBtn: FYGE.Sprite
  startBtn: FYGE.Button

  IndexSceneData: {
    needTikectCount: number,
    gameTimeLimit: number
  }

  protected initUi(): void {

    this.IndexSceneData = getWebData(WebNetName.index).data

    UI.Sp(this, 'indexSceneBack.jpg')

    UI.MoiveClip(this, '首页氛围.svga')

    const indexSceneLogo = UI.Ctn(this, 0, 360)
    UI.Sp(indexSceneLogo, 'indexSceneLogo.png')

    const textMap = Tools.getNumTextures('')
    textMap['s'] = RES.getRes('s.png')
    const countDownTimeFromLogo = indexSceneLogo.addChild(new FYGE.BitmapText(textMap))
    countDownTimeFromLogo.position.set(395, 103)
    countDownTimeFromLogo.text = `${this.IndexSceneData.gameTimeLimit}s`

    this.ruleBtn = UI.Sp(this, 'ruleBtn.png', 0, 230)

    this.awardBtn = UI.Sp(this, 'awardBtn.png', 750 - 136, 230)

    const startBtnCont = UI.Ctn(this, (750 - 374) / 2, 1150)
    this.startBtn = UI.Btn(startBtnCont, 'startBtn.png', this.onJump2Scene, this)
    UI.Txt(startBtnCont, `消耗${this.IndexSceneData.needTikectCount}门票`, 24, '#000000', FYGE.TEXT_ALIGN.CENTER, 374, 0, 120)

    sendLog(LOG_TYPE.EXPOSURE, 1)
    sendLog(LOG_TYPE.EXPOSURE, 2)
  }

  @PromiseAwait
  async onJump2Scene() {
    sendLog(LOG_TYPE.CLICK, 2)
    const {
      success
    } = await sendWebNet(WebNetName.start)
    if (success) {
      changeScene(ParkourScene)
    }
  }

  onShowRulePanel() {
    showPanel(RuleModal, {
      ruleTxt: getWebData(WebNetName.projectRule).data.split(/===+/)[0]
    })
  }

  onJump2AwardPage() {
    window.location.href = 'awardPage.html'
  }

  initEvents(): void {
    this.ruleBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onShowRulePanel, this)

    this.awardBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onJump2AwardPage, this)
  }

  removeEvents(): void {
    this.ruleBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onShowRulePanel, this)

    this.awardBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onJump2AwardPage, this)
  }
}