import { ParkourGameConfig } from './ParkourGameConfig';

type rectData = {
  x: number,
  y: number,
  w: number,
  h: number
}

function onCollsionJudgeRect(rectCont1: rectData, rectCont2: rectData) {
  return Math.abs(rectCont1.x + rectCont1.w / 2 - rectCont2.x - rectCont2.w / 2) < (rectCont1.w + rectCont2.w) / 2 && Math.abs(rectCont1.y + rectCont1.h / 2 - rectCont2.y - rectCont2.h / 2) < (rectCont1.h + rectCont2.h) / 2
}

export namespace CollisionDetection {
  export function onCollsionJudge(cont1: PythicCont, cont2: PythicCont) {
    if (!cont1 || !cont2) return false
    if (cont1.type === cont2.type) {
      if (cont1.type === 'rect') {
        // onCollsionJudgeRect((cont1 as RectPhysicsCont).onGetCollisionData(), (cont2 as RectPhysicsCont).onGetCollisionData()) && console.log((cont1 as RectPhysicsCont).onGetCollisionData(), (cont2 as RectPhysicsCont).onGetCollisionData())
        return onCollsionJudgeRect((cont1 as RectPhysicsCont).onGetCollisionData(), (cont2 as RectPhysicsCont).onGetCollisionData())
      }
    }
  }
}

class CollisionComposite {

  pythicContList: Array<PythicCont> = [];

  constructor() {
  }

  addPythicCont(pythicCont: PythicCont) {
    this.pythicContList.push(pythicCont)
  }
}

export const CollisionCompositeIns = new CollisionComposite()

export class PythicCont{
  x: number
  y: number
  parent: FYGE.Container
  type: 'rect' | 'circle'

  draw() {}

  /**
   * 记录parent
   * @param parent 
   */
  initParent (parent: FYGE.Container) {
    this.parent = parent
  }

  /**
   * 获取 碰撞检测数据
   */
  onGetCollisionData() {
  }

  get pythicPos() {
    if (!this.parent) {
      console.error('pythicPos parent is null')
      return
    }
    const pos = this.parent.localToGlobal(new FYGE.Point())
    return {
      x: pos.x + this.x * this.parent.scale.x,
      y: pos.y + this.y * this.parent.scale.x
    }
  }
}

export function WithCollisionDetection<T extends { new(...args: any[]): FYGE.Container }>(TargetClass: T) {
  return class extends TargetClass {
    [x: string]: any;

    constructor(...args: any[]) {
      super(...args)
    }

    addPythicCont(cont: PythicCont) {
      this.PythicCont = cont
      cont.initParent(this)
      // 如果开启了 debug  就添加一个碰撞检测的矩形
      if (ParkourGameConfig.CommonConfig.CollisionDebug) {
        cont.draw()
      }
    }
  }
  
}

export class RectPhysicsCont extends PythicCont{
  w: number
  h: number

  constructor(x: number, y: number, w: number, h: number) {
    super()
    this.x = x
    this.y = y
    this.w = w
    this.h = h
    this.type = 'rect'
  }

  draw(): void {
    const parent = this.parent
    const p = parent.addChild(new FYGE.Shape())
      .beginFill('#000000')
      .drawRect(this.x, this.y, this.w, this.h)
      .endFill()
    p.alpha = 0.4
  }

  onGetCollisionData() {
    return {
      ...this.pythicPos,
      w: this.w * this.parent.scale.x, // 缩放
      h: this.h * this.parent.scale.y
    }
  }
}