import { Tools } from './../tools/Tools';
import { layers } from '../../module/views/layers';
import { GDispatcher } from '../Game';
import UI from '../tools/UI';
import { Module } from './../../module/views/Module';
import { ConveyorBeltItem } from './comp/ConveyorBelt';
import { ExtraConfig, ExtraEvents } from './ExtraConfig';
import { ParkourGameEvents } from './ParkourGameConfig';
import { CountDownWithTween, CountDownWithTweenCls, PromiseAwait } from './utils';
import { getWebData, sendWebNet, WebNetName } from '../tools/WebNet';
import { RES } from '../../module/RES';
import { changeScene, showPanel } from '../../module/ctrls';
import { ResultModal } from '../panels/ResultModal';
import { duiba_md5 } from '../../module/tools/security';
import { IndexScene } from './IndexScene/IndexScene';
import { RescurrectionModal } from '../panels/RescurrectionModal';

export class BalalaScene extends Module {
  get groupNames(): string[] {
    return ['GameScene']
  }

  MovieClipList: FYGE.MovieClip[] = []
  CountDownAniMoiveClip: FYGE.MovieClip
  CountDownAniMoiveClipCont: FYGE.Container

  UiCont: FYGE.Container

  isInShieldTime: boolean = false
  shieldTimer: any

  scoreText: FYGE.BitmapText
  _score: number = 0

  countDownFactory: CountDownWithTweenCls

  StartGameData: {
    startId: number,
    newGuide: boolean
  }

  resurrectionTimes: number // 复活次数

  get score() {
    return this._score
  }

  set score(v: number) {
    this.scoreText.text = '+' + (~~v) + ''
  }

  countDownText: FYGE.BitmapText
  set countDownNum(v: number) {
    this.countDownText.text = v + ''
  }

  constructor(props?: any) {
    super(props)
    this.initEvents()
  }

  initUi(): void {

    this.StartGameData = getWebData(WebNetName.start).data

    const BaseScene = UI.Ctn(this)
    UI.Sp(BaseScene, 'back.png')
    this.MovieClipList.push(UI.MoiveClip(BaseScene, '跑道.svga'))
    this.MovieClipList.push(UI.MoiveClip(BaseScene, '背景移动元素.svga'))
    this.MovieClipList.push(UI.MoiveClip(BaseScene, '路架子.svga'))

    this.UiCont = UI.Ctn(BaseScene)
    BaseScene.setChildIndex(this.UiCont, 10000)

    const scoreBoardCont = UI.Ctn(BaseScene, 0, 200)
    UI.Sp(scoreBoardCont, 'scoreboardback.png')
    const tmap = Tools.getNumTextures('l')
    tmap['+'] = RES.getRes('l+.png')
    this.scoreText = scoreBoardCont.addChild(new FYGE.BitmapText(tmap))
    this.scoreText.position.set(30, 28)
    this.scoreText.textAlign = FYGE.TEXT_ALIGN.LEFT
    this.score = 0

    const countDownCont = UI.Ctn(BaseScene, 750 - 171, 200)
    UI.Sp(countDownCont, 'countdownback.png')
    this.countDownText = countDownCont.addChild(new FYGE.BitmapText(Tools.getNumTextures('')))
    this.countDownText.position.set(120, 53)
    this.countDownNum = ExtraConfig.CountDownTime
    this.countDownFactory = new CountDownWithTweenCls(ExtraConfig.CountDownTime * 1000, (t) => {
      this.countDownNum = ~~(t / 1000)
    }, () => {
      this.onPause()
      this.onGameOver()
    })


    this.onPause()

    if (this.StartGameData.newGuide) {
      this.onShowGameGuidance(() => {
        this.onGameRestart()
      })
    } else {
      this.onGameRestart()
    }

    // setTimeout(() => {
    //   this.onGameRestart()
    // }, 1000)
  }

  GuidanceCont: FYGE.Container
  realRenderGuideCont: FYGE.Container
  onShowGameGuidance(cb: Function) {
    let _GuidanceCont = this.GuidanceCont
    let realRenderGuideCont = this.realRenderGuideCont
    if (!this.GuidanceCont) {
      _GuidanceCont = this.GuidanceCont = UI.Ctn(layers.topLayer)
      UI.Sp(_GuidanceCont, 'GuideBack.jpg')
      realRenderGuideCont = this.realRenderGuideCont = UI.Ctn(_GuidanceCont)
      UI.Sp(_GuidanceCont, 'next-step.png', 375, 1370).anchorTexture.set(0.5, 0.5)
    }

    const showStep = (n: number) => {
      realRenderGuideCont.removeAllChildren()
      switch(n) {
        case 0:
          realRenderGuideCont.addChild(new FYGE.Graphics())
            .clear()
            .beginFill(0x000000, 0.65)
            .drawRect(0,0,750,1624)
            .endFill()
            .beginHole()
            .drawCircle(375, 1150, 160)
            .endHole()
          UI.Sp(realRenderGuideCont, 'Guide1.png', 375, 1150).anchorTexture.set(0.5, 0.5)
          UI.Txt(realRenderGuideCont, '左右滑动控制车子移动', 30, '#ffffff', FYGE.TEXT_ALIGN.CENTER, 750, 0,920)
          break
        case 1:
          realRenderGuideCont.addChild(new FYGE.Graphics())
            .clear()
            .beginFill(0x000000, 0.65)
            .drawRect(0,0,750,1624)
            .endFill()
            .beginHole()
            .drawCircle(220, 760, 60)
            .endHole()
          UI.Txt(realRenderGuideCont, `撞击金币可得${ExtraConfig.CoinsScore}分`, 30, '#ffffff', FYGE.TEXT_ALIGN.CENTER, 750, 0,920)
          break
        case 2:
          realRenderGuideCont.addChild(new FYGE.Graphics())
            .clear()
            .beginFill(0x000000, 0.65)
            .drawRect(0,0,750,1624)
            .endFill()
            .beginHole()
            .drawCircle(378, 570, 60)
            .endHole()
          UI.Txt(realRenderGuideCont, `撞击护盾可受${ExtraConfig.shieldTime / 1000}秒保护\n无障碍前进并自动吸收赛道中的金币`, 30, '#ffffff', FYGE.TEXT_ALIGN.CENTER, 750, 0, 680)
          break
        case 3:
          realRenderGuideCont.addChild(new FYGE.Graphics())
            .clear()
            .beginFill(0x000000, 0.65)
            .drawRect(0,0,750,1624)
            .endFill()
            .beginHole()
            .drawCircle(536, 725, 60)
            .endHole()
          UI.Txt(realRenderGuideCont, `注意！躲避障碍 触碰则游戏结束`, 30, '#ffffff', FYGE.TEXT_ALIGN.CENTER, 750, 0, 920)
          break
        case 4:
          this.stage.removeEventListener(FYGE.MouseEvent.CLICK, showNextStep)
          _GuidanceCont.visible = false
          cb()
          break
      }
    }

    let currStep = 0
    function showNextStep() {
      showStep(currStep++)
    }
    showNextStep()
    this.stage.addEventListener(FYGE.MouseEvent.CLICK, showNextStep)
  }

  initEvents(): void {
    GDispatcher.addEventListener(ParkourGameEvents.GAME_COLLESION, this.onGameEleCollision, this)

    GDispatcher.addEventListener(ParkourGameEvents.CONVEYOR_MOVE_Y, this.onCalcScore, this)
  }

  removeEvents(): void {
    GDispatcher.removeEventListener(ParkourGameEvents.GAME_COLLESION, this.onGameEleCollision, this)

    GDispatcher.removeEventListener(ParkourGameEvents.CONVEYOR_MOVE_Y, this.onCalcScore, this)
  }

  /**
   * 计算分数
   * @param e 
   */
  onCalcScore(e: FYGE.Event) {
    this.score = e.data
  }

  /**
   * 碰撞检测
   * @param e 
   */
  onGameEleCollision(e: FYGE.Event) {
    const CollisionContainer: ConveyorBeltItem = e.data
    if (CollisionContainer.uniqueKey === 'shit') {
      if (!this.isInShieldTime) {
        this.onPause()
        this.onJudgeIsRealDie()
      }
    } else if (CollisionContainer.uniqueKey === 'coins') {
      this.score += ExtraConfig.CoinsScore
    } else if (CollisionContainer.uniqueKey === 'protect') {
      this.onGetShieldTime()
    }
  }

  /**
   * 获取护盾时间
   */
  onGetShieldTime() {
    this.isInShieldTime = true
    this.shieldTimer && clearTimeout(this.shieldTimer)
    GDispatcher.dispatchEvent(ExtraEvents.GET_PROTECT)
    this.shieldTimer = setTimeout(() => {
      GDispatcher.dispatchEvent(ExtraEvents.REMOVE_PROTECT)
      this.isInShieldTime = false
    }, ExtraConfig.shieldTime)
  }

  /**
   * 游戏开始之前的 倒计时
   */
  @PromiseAwait
  onGameStartBeforeCountdownAni() {
    return new Promise<void>((resolve, reject) => {
      let _CountDownAniMoiveClipCont = this.CountDownAniMoiveClipCont
      if (!_CountDownAniMoiveClipCont) {
        _CountDownAniMoiveClipCont = this.CountDownAniMoiveClipCont = UI.Ctn(layers.topLayer)
        UI.Rect(_CountDownAniMoiveClipCont, 750,1624, 0x000000,0,0,0,0.6)
        this.CountDownAniMoiveClip = UI.MoiveClip(_CountDownAniMoiveClipCont, '倒计时.svga', 0, 200)
      }
      _CountDownAniMoiveClipCont.visible = true
      this.CountDownAniMoiveClip.startAniRange(0, this.CountDownAniMoiveClip.totalFrames, 1, () => {
        _CountDownAniMoiveClipCont.visible = false
        resolve()
      })
    })
  }

  async onGameStart() {
    this.onResume()
    this.countDownFactory.start()
    GDispatcher.dispatchEvent(ParkourGameEvents.GAME_RESTART)
  }

  async onGameRestart() {
    // TODO do something
    this.score = 0
    this.resurrectionTimes = 0
    this.countDownNum = ExtraConfig.CountDownTime
    GDispatcher.dispatchEvent(ParkourGameEvents.GAME_RESET)
    await this.onGameStartBeforeCountdownAni()
    console.log('倒计时结束')
    this.onGameStart()
  }

  /**
   * 复活
   */
  async onResurrectionForResume() {
    await sendWebNet(WebNetName.revive)
    this.resurrectionTimes += 1
    this.onResume()
    this.countDownFactory.resume()
    GDispatcher.dispatchEvent(ParkourGameEvents.GAME_RESUME)
  }

  onPause() {
    this.countDownFactory.stop()
    this.MovieClipList.forEach(item => {
      item.stop()
    })
    GDispatcher.dispatchEvent(ParkourGameEvents.GAME_PAUSE)
    
  }

  @PromiseAwait
  async onJudgeIsRealDie() {
    if (this.resurrectionTimes === ExtraConfig.RescurrectionTimes) {
      this.onGameOver()
    } else {
      const {
        success
      } = await sendWebNet(WebNetName.pause, {
        startId: getWebData(WebNetName.start).data.startId
      })
      success && showPanel(RescurrectionModal, {
        onGiveUp: () => {
          this.onGameOver()
        },
        onResurrection: () => {
          this.onResurrectionForResume()
        }
      })
    }
  }

  @PromiseAwait
  async onGameOver() {
    const startId = getWebData(WebNetName.start).data.startId
    const sign = duiba_md5(`score=${this.score}&startId=${startId}&key=dui88zhcx715znq1234`)
    const {
      success,
      data
    } = await sendWebNet(WebNetName.submit, {
      startId,
      score: this.score,
      sign
    })
    if (success) {
      showPanel(ResultModal, {
        coins: data.sendCount,
        score: this.score,
        onAgain: () => {
          this.onGameRestart()
        }
      })
    } else {
      changeScene(IndexScene)
    }
  }

  /**
   * 动效开始播放
   */
  onResume(resume: boolean = true) {
    this.countDownFactory.resume()
    this.MovieClipList.forEach(item => {
      item.play()
    })
  }

  destroy() {
    super.destroy()
    layers.topLayer.removeChild(this.GuidanceCont)

    layers.topLayer.removeChild(this.CountDownAniMoiveClip)
  }
  
}