import { Panel } from "../../module/views/Panel"
import UI from "../tools/UI"

interface BeforeGameMadalInfer {
  onConfirm: Function
}

let protocolSection

const ProtocolContent = `<p style="white-space: break-spaces"><span>    感谢您参与此次活动！我们非常重视您的个人信息和隐私保护。\n<span><span>    为了更好的保障您的权益，请您认真阅读<span style="color:#c23d25;margin: 0 5px" class="protocol-text">《隐私协议》</span>的全部内容，同意并接受全部条款后开始使用我们的产品和服务。</span></p>`

export class RuleModal extends Panel {
  onConfirm: Function
  constructor(data?: any) {
    super()
  }

  get groupNames(): string[] {
    return ['RuleModal']
  }

  RoleContainer: FYGE.Container
  initUi() {
    const RoleContainer = this.RoleContainer = UI.Ctn(this, (750 - 547) / 2, (1624 - 697) / 2)
    UI.Sp(RoleContainer, 'ruleModalBack.png')

    UI.Btn(RoleContainer, 'close-btn.png', this.hidePanel, this, 250, 760)
  }

  start(data?: any): void {
    super.start()
      //原先视图上有一个
		// this.removeChild(this.ruleTxt);
		//文案
		// var scroll = this.addChild(new FYGE.ScrollPage(610, 816, 100, true, false))
		// scroll.position.copy(this.ruleTxt.position)

		// //加文案
		// var txt = scroll.view.addChild(Tools.getText(
		// 	ruleStr,
		// 	30,//this.ruleTxt.size,
		// 	this.ruleTxt.fillColor,
		// 	FYGE.TEXT_ALIGN.LEFT,
		// 	610
		// ))
		// //多行设置
		// txt.lineType = FYGE.TEXT_lINETYPE.MULTI;
		// //行间距设置
		// txt.lineSpacing = 20;
		// //滚动最大长度按文本高度
		// scroll.maxDistance = txt.textHeight

		if (!protocolSection) {//避免文案过长，用这种方式
			document.getElementById("cusEngine").style.position = "absolute"
			protocolSection = document.createElement('section');
			protocolSection.id = "protocol-section";
			protocolSection.style.overflowX = "hidden";
			protocolSection.style.overflowY = "auto";
			protocolSection.style.width = 460 + "px";
			protocolSection.style.height = 476 + "px";
			protocolSection.style.lineHeight = 48 + "px";
			protocolSection.style.fontSize = 28 + 'px';
			protocolSection.style.color = '#503423';
			protocolSection.style.whiteSpace = "pre-line";
		}
		var rule = this.RoleContainer.addChild(new FYGE.FloatDisplay());
		rule.position.set(40, 120)
    protocolSection.innerHTML = data.ruleTxt || ProtocolContent;
		rule.init(protocolSection);
  }

  initEvents(): void {
  }

  removeEvents(): void {
  }

}