import { changeScene } from "../../module/ctrls";
import { Panel } from "../../module/views/Panel";
import { IndexScene } from "../scenes/IndexScene/IndexScene";
import { promiseAwaitFunc } from "../scenes/utils";
import UI from "../tools/UI";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../tools/WebNet";

export class ResultModal extends Panel {
  get groupNames(): string[] {
    return ['ResultModal']
  }

  initUi() {
    sendLog(LOG_TYPE.EXPOSURE, 7)
    sendLog(LOG_TYPE.EXPOSURE, 8)
    sendLog(LOG_TYPE.EXPOSURE, 9)

    const roleCont = UI.Ctn(this, (750 - 667) / 2 + 10, 170)

    UI.Sp(roleCont, 'resultModalback.png')

    UI.Txt(roleCont, `恭喜获得${this.data && this.data.coins || 0}周年币`, 36, '#fd4ca4', FYGE.TEXT_ALIGN.CENTER, 667, -10, 700)

    UI.Txt(roleCont, `${this.data && this.data.score || 0}`, 36, '#fce461', FYGE.TEXT_ALIGN.CENTER, 667, -10, 410)

    UI.Btn(roleCont, 'cancelBtn.png', () => {
      changeScene(IndexScene)
      this.hidePanel()

      sendLog(LOG_TYPE.CLICK, 8)
    }, this, 60, 810)

    UI.Btn(roleCont, 'oneMoreTime.png', promiseAwaitFunc(async () => {
      sendLog(LOG_TYPE.CLICK, 9)

      const {
        success
      } = await sendWebNet(WebNetName.start)
      if (success) {
        this.data && this.data.onAgain && this.data.onAgain()
        this.hidePanel()
      } else {
        changeScene(IndexScene)
        this.hidePanel()
      }
    }), this, 320, 810)
  }
}