import { CountDownFac, CountDownWithTweenCls } from './../scenes/utils';
import { ExtraConfig } from './../scenes/ExtraConfig';
import { Panel } from "../../module/views/Panel";
import UI from "../tools/UI";
import { LOG_TYPE, sendLog } from '../tools/WebNet';

export class RescurrectionModal extends Panel {
  get groupNames(): string[] {
    return ['rescurrectionModal']
  }
  roleCont: FYGE.Container
  protected initUi(): void {
    sendLog(LOG_TYPE.EXPOSURE, 4)
    sendLog(LOG_TYPE.EXPOSURE, 6)
    sendLog(LOG_TYPE.EXPOSURE, 5)

    const roleCont = this.roleCont = UI.Ctn(this, (750 - 547) / 2, 812 - 389 / 2)

    UI.Sp(roleCont, 'rescurrectionModalBack.png')

    const t = UI.Txt(roleCont, ExtraConfig.RescurrectionText, 36, '#f7468d', FYGE.TEXT_ALIGN.CENTER, 507, 20, 70)
    t.lineType = FYGE.TEXT_lINETYPE.MULTI

    const bt = UI.Txt(roleCont, `是否复活: ${ExtraConfig.tt}s`, 28, '#f7468d', FYGE.TEXT_ALIGN.CENTER, 507, 20, 330)
    
    const simpleCountDonwFac = CountDownFac(ExtraConfig.tt)
    simpleCountDonwFac.start((t) => {
      bt.text = `是否复活: ${t}s`
    }, () => {
      this.hidePanel()
      this.data && this.data.onGiveUp()
    })

    UI.Btn(roleCont, 'fkBtn.png', () => {
      sendLog(LOG_TYPE.CLICK, 6)

      simpleCountDonwFac.end()
      this.hidePanel()
      this.data && this.data.onGiveUp()
    }, this, 270, 230)

    UI.Btn(roleCont, 'lookBtn.png', () => {
      sendLog(LOG_TYPE.CLICK, 5)

      simpleCountDonwFac.end()
      this.onShowPreviewImg()
    }, this, 20, 230)
  }

  onShowPreviewImg() {
    this.roleCont.visible = false
    FYGE.GlobalLoader.loadImage((s, img) => {
      const texture = FYGE.Texture.from(img)
      const sprite = new FYGE.Sprite(texture)

      sprite.width = 700
      sprite.height = 700 * img.height / img.width

      const PreviewCont = UI.Ctn(this,25, (1624 - sprite.height) / 2)
      PreviewCont.addChild(sprite)
      const ct = UI.Txt(PreviewCont, '4s', 36, '#ffffff', FYGE.TEXT_ALIGN.CENTER, 700, 0, sprite.height + 30)

      const countDownFac = new CountDownWithTweenCls(3000, (t) => {
        ct.text = `${~~(t/1000)}s`
      }, () => {
        this.hidePanel()
        this.data && this.data.onResurrection()
      })
      countDownFac.start()
      // if (img.width > img.height) {
        
      // } else {

      // }

    }, ExtraConfig.PreviewImg)
  }


}