
/**
 * 回收池
 */
export class GPool {
    private static pool: Map<any, any[]> = new Map();

    /**
     * 取出
     * @param name 
     */
    public static takeOut<T>(name: any): T {
        const storeMapValue = this.pool.get(name)
        if (storeMapValue && storeMapValue.length) {
            // console.log('取出')
            return storeMapValue.shift();
        }
        return null;
    }

    /**
     * 放入对象池
     * @param name 
     * @param poolItem 
     */
      public static takeIn(name: any, poolItem: any) {
        // console.log('放入对象池')
        const storeMapValue = this.pool.get(name);
        if (!storeMapValue) {
            const newStoreMapValue = [];
            this.pool.set(name, newStoreMapValue)
            newStoreMapValue.push(poolItem);
        } else {
            storeMapValue.push(poolItem);
        }
    }

    // /**
    //  * 回收
    //  * @param name 
    //  * @param obj 
    //  */
    // public static recover(name: string, obj) {
    //     if (!this.pool[name]) {
    //         this.pool[name] = [];
    //     }
    //     this.pool[name].push(obj);
    // }
}