/*
 * utils.mjs.js
 * Created by 还有醋v on 2022/5/27.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */

import childProcess from "child_process";

export function _debounce(fn, delay = 1000) {
	let timer = null;
	return function (...args) {
		timer && clearTimeout(timer);
		timer = setTimeout(fn, delay, ...args);
	};
}

export function runScript(scriptPath, callback) {
	
	let invoked = false;
	
	const process = childProcess.fork(scriptPath);
	
	process.on('error', (err) => {
		if (invoked) return;
		invoked = true;
		callback(err);
	});
	
	process.on('exit', (code) => {
		if (invoked) return;
		invoked = true;
		const err = code === 0 ? null : new Error('exit code ' + code);
		callback(err);
	});
	
}

