package notOriPreview;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.*;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class Test {

    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setMaster("local").
                setAppName("RDDToDataFrameByReflection");
        JavaSparkContext sc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);

        List<TestPersonInfo> personList=new ArrayList<>();
        personList.add(new TestPersonInfo("Andy","32"));
        personList.add(new TestPersonInfo("Michael","23"));
        personList.add(new TestPersonInfo("Justin","19"));

        JavaRDD<TestPersonInfo> personJavaRDD = sc.parallelize(personList);
        System.out.println("1. 直接构建出 JavaRDD<Person>");

        Encoder<TestPersonInfo> personEncoder = Encoders.bean(TestPersonInfo.class);
        DataFrame personDF = sqlContext.createDataFrame(personList, TestPersonInfo.class);
        System.out.println("3. 直接构建出 Dataset<Row>");
        personDF.show();
        personDF.printSchema();

        JavaRDD<Row> personRDD = personDF.toJavaRDD();
        System.out.println(personRDD.count());
        System.out.println(personRDD.count());
        JavaRDD<Map<String,String>> personMapRDD=personRDD.map(new Function<Row,Map<String, String>>() {

                    private static final long serialVersionUID = 1L;

                    @Override
                    public Map<String,String> call(Row row) throws Exception {
                        Map<String, String> sampleMap = new HashMap<String, String>();
                        sampleMap.put("name",row.getAs("name").toString());
                        sampleMap.put("age",row.getAs("age").toString());
                        return (sampleMap);

                    }
                }
        );

        System.out.println(personMapRDD.collect());

    }
}