package cn.com.duiba.nezha.compute.common.model.pacing;

import java.util.*;

public class SlotRecommender {
    public static List<OrientResultInfo> recommend(List<OrientInfo> orientlist, List<BlackInfo> blacklist) {
        Set<List<Long>> OrientSet = new HashSet<List<Long>>();
        for (OrientInfo orient:orientlist) {

            boolean isManagered = orient.isManagered; //是否为托管配置
            Integer chargeType = orient.chargeType;  //计费方式
            Long target = orient.target;  //目标成本
            Long fee = orient.fee; //出价
            Double cvr = orient.cvr;
            Double confidence = orient.confidence;   //置信度
            Double bias = orient.bias;

            Random r=new Random();
            Double x=r.nextDouble();
            Double p_convert_cost=fee/cvr;

            List<Long> OrientInfoList=new ArrayList<Long>();
            OrientInfoList.add(orient.advertId);
            OrientInfoList.add(orient.orientId);

            //////////ocpc
            if (isManagered && chargeType == 1) {
                //剔除有发券的预估偏差较高定向
                if (bias < 3 && confidence > 0) {

                    OrientSet.add(OrientInfoList);

                    // 无发券，使用行业-广告位或广告维度偏差<2，定向几率0.8 (这里的偏差=0，代表空值)
                } else if (bias < 2 && bias != 0 && confidence == 0 && x>0.2) {
                    OrientSet.add(OrientInfoList);

                    //无发券，使用行业-广告位或广告维度偏差>2，定向几率0.2
                }else if (bias >= 2 && bias != 0 && confidence == 0 && x>0.8) {
                    OrientSet.add(OrientInfoList);

                    //无发券，偏差为空，定向几率0.5
                }else {
                    if (x>0.5) {OrientSet.add(OrientInfoList);}
                }
            }

            ////////cpc
            else if (isManagered && chargeType == 0) {
                if (confidence > 0 && p_convert_cost<2*target) {OrientSet.add(OrientInfoList);}
                if (confidence == 0 && bias != 0 && p_convert_cost<0.8*target) {OrientSet.add(OrientInfoList);}
                if (confidence == 0 && bias == 0 && p_convert_cost<0.7*target) {OrientSet.add(OrientInfoList);}
            }

        }



        Set<List<Long>> BlackSet = new HashSet<List<Long>>();
        for (BlackInfo black:blacklist){
            List<Long> BlackInfoList=new ArrayList<Long>();
            BlackInfoList.add(black.advertId);
            BlackInfoList.add(black.orientId);
            BlackSet.add(BlackInfoList);
        }


        //剔除黑名单
        OrientSet.removeAll(BlackSet);

        List<OrientResultInfo> orientResultList = new ArrayList<OrientResultInfo>();
        for(List<Long> resultList:OrientSet){
            OrientResultInfo orientResultInfo = new OrientResultInfo(resultList.get(0), resultList.get(1));
            orientResultList.add(orientResultInfo);
        }
        return orientResultList;
    }
}
