package blackwhitenamelist;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackWhiteNameListRule {

    public static Map<String, String> whiteBlackNameListRule(List<CostConvertInfo> infoList) {
        Map<String, String> nameListMap = new HashMap<String, String>();
        for (int i = 0; i < infoList.size(); i++) {
            //System.out.println(infoList.get(i));
            CostConvertInfo costConvertInfo=infoList.get(i);
            String type = costConvertInfo.type;
            String tag = costConvertInfo.tag;
            Integer grained = costConvertInfo.grained;
            String whiteBlackKey = costConvertInfo.appId + "_" + costConvertInfo.slotId + "_" + costConvertInfo.activityId + "_" + costConvertInfo.orientationId + "_" + costConvertInfo.advertId;
            String fuseKey = costConvertInfo.orientationId + "_" + costConvertInfo.advertId;
            Float costConvertAd = costConvertInfo.adCostConvert;  //某广告的全局成本 为空会默认成0  所以条件要>0

            if (type.equals("day") && tag.equals("2") && grained==1 && costConvertAd>0) {
                long luanch_cnt = costConvertInfo.launchCnt;
                Long costKey1dZ = costConvertInfo.cost;
                Long convertKey1dZ = costConvertInfo.convert;
                if (convertKey1dZ==0 && costKey1dZ>1000) {
                    nameListMap.put(fuseKey, "fuse_1");
                }
                else if (convertKey1dZ>0) {
                    Long costConvertKey1dZ = costKey1dZ / convertKey1dZ;
                    Float diffR1dZ = costConvertKey1dZ / costConvertAd;
                    if (diffR1dZ >= 3) {
                        nameListMap.put(fuseKey, "fuse_1");
                    }
                }
            } else if (type.equals("hour") && tag.equals("2") && grained==0  && costConvertAd>0) {
                long luanch_cnt = costConvertInfo.launchCnt;
                Long costKey1h = costConvertInfo.cost;
                Long convertKey1h = costConvertInfo.convert;
                if (convertKey1h==0 && costKey1h>1000) {
                    nameListMap.put(whiteBlackKey, "b3_1");
                }
                else if (convertKey1h>0) {
                    Long costConvertKey1h = costKey1h / convertKey1h;
                    Float diffR1h = costConvertKey1h  / costConvertAd;
                    if (diffR1h >= 2) {
                        nameListMap.put(whiteBlackKey, "b3_1");
                    }
                }

            } else if (type.equals("day") && tag.equals("2")  && grained==0  && costConvertAd>0) {
                long luanch_cnt = costConvertInfo.launchCnt;
                Long costKey1d = costConvertInfo.cost;
                Long convertKey1d = costConvertInfo.convert;
                if (convertKey1d==0 && costKey1d>5000) {
                    nameListMap.put(whiteBlackKey, "b1_5");
                }
                else if (convertKey1d==0 && costKey1d>1000) {
                    nameListMap.put(whiteBlackKey, "b2_3");
                }
                else if (convertKey1d>0) {
                    Long costConvertKey1d = costKey1d / convertKey1d;
                    Float diffR1d = costConvertKey1d/ costConvertAd;
                    if (diffR1d > 2.5 && diffR1d <= 3.5) {
                        nameListMap.put(whiteBlackKey, "b1_5");
                    } else if (diffR1d >= 1.5 && diffR1d < 2.5) {
                        nameListMap.put(whiteBlackKey, "b2_3");
                    } else if (diffR1d < 0.5) {
                        nameListMap.put(whiteBlackKey, "w_1");
                    }
                }

            }
        }
        return nameListMap;
    }
}
