package com.javademo.cases;

import org.junit.Test;

import com.alibaba.fastjson.JSONObject;
import com.javademo.utils.Config;

import macaca.client.MacacaClient;
import macaca.client.common.GetElementWay;

public class macacaTest {
	@Test
	public void androidTest() throws Exception{
		MacacaClient driver = new MacacaClient();
		// 初始化应用基础信息
		JSONObject props = new JSONObject();
		props.put("app", Config.ADR_APP);//app路径
		props.put("platformName", "Android");//平台
		props.put("reuse", Config.REUSE);// 覆盖安装
	    
		JSONObject desiredCapabilities = new JSONObject();
		desiredCapabilities.put("desiredCapabilities", props);
	    
		
		//初始化driver
	    driver.initDriver(desiredCapabilities);
		
	    //输入账号
	    driver.getElement(GetElementWay.ID, "com.github.android_app_bootstrap:id/mobileNoEditText").sendKeys("test");
	    //输入密码
	    driver.getElement(GetElementWay.NAME, "please input password").sendKeys("123");
	    //点击登陆
	    driver.getElement(GetElementWay.ID, "com.github.android_app_bootstrap:id/login_button").click();

	 }
	@Test
	public void iosTest() throws Exception{
		MacacaClient driver = new MacacaClient();
		// 初始化应用基础信息
		JSONObject props = new JSONObject();
		props.put("app", Config.IOS_APP);//app路径
		props.put("platformName", "iOS");//平台
		props.put("deviceName", Config.IOS_DEVICE_NAME);//设备名称
		props.put("reuse", Config.REUSE);//覆盖安装
        JSONObject desiredCapabilities = new JSONObject();
		desiredCapabilities.put("desiredCapabilities", props);
		//初始化driver
		driver.initDriver(desiredCapabilities);
		
		//输入账号
		driver.getElement(GetElementWay.ID, "please input username").sendKeys("test");
		//输入密码
	    driver.getElement(GetElementWay.NAME, "please input password").sendKeys("123");
	    //点击登陆
	    driver.getElement(GetElementWay.NAME, "Login").click();
		
		
		
	}
	@Test
	public void webTest() throws Exception{
		MacacaClient driver = new MacacaClient();
		// 初始化应用基础信息
		JSONObject props = new JSONObject();
		props.put("browserName", "electron");//浏览器名称
		props.put("platformName", "desktop");//平台
	    JSONObject desiredCapabilities = new JSONObject();
		desiredCapabilities.put("desiredCapabilities", props);
	    
		
		//初始化driver
	    driver.initDriver(desiredCapabilities);
	    
	    driver.get("http://www.baidu.com");
		driver.elementById("kw").sendKeys("macaca");
		
		driver.quit();
		
	}

}
