export function hex2rgb(hex) {
    return {
        r: (hex >> 16) & 0xff,
        g: (hex >> 8) & 0xff,
        b: hex & 0xff,
    }
}

export function rgb2hex(color) {
    color = ((color.r << 16) + (color.g << 8) + (color.b | 0)).toString(16)
    return `#${'000000'.substring(0, 6 - color.length)}${color}`
}