export default function(action) {
    const keys = Object.keys(action)

    function start(option) {
        const result = {}
        let update, complete, total = {start: 0, end: 0}

        if (option instanceof Function) update = option
        else ({update, complete} = option)

        const animes = keys.map(key => {
            total.start++
            return action[key].start({
                update: v => {
                    result[key] = v
                    total.start === keys.length && update(result)
                },

                complete: () => {
                    total.end++
                    total.end === keys.length && complete && complete()
                }
            })
        })

        return {
            stop() {
                animes.forEach(anime => anime.stop())
            }
        }
    }

    return {start}
}