import {curve, easing, tween, composite, utils} from './core'

HTMLElement.prototype.on = function(...args) {
    this.addEventListener(...args)
    return this
}

const player = document.querySelector('.player')


document.body.on('pointerdown', ev => {
    const target = ev.target
    if (target.classList.contains('dot')) {
        target.remove()
    } else if (target === document.body) {
        const
            dot = document.createElement('div'),
            {pageX: x, pageY: y} = ev

        dot.classList.add('dot')
        dot.style.top = `${y}px`
        dot.style.left = `${x}px`
        dot.dataset.position = JSON.stringify({x, y})
        document.body.appendChild(dot)
    } else if (target.classList.contains('btn-run')) {
        target.classList.contains('bezier') && run('bezier')
        target.classList.contains('cubic-bezier') && run('cubicBezier')
        target.classList.contains('catmull-rom') && run('catmullRom')
        target.classList.contains('tween') && run('tween')
    } else if (target.classList.contains('btn-clear')) {
        clear()
    }
})

function run(action) {
    const dots = document.querySelectorAll('.dot')

    document.querySelectorAll('.mini-dot').forEach(child => child.remove())
    player.setAttribute('style', '')

    if (action === 'bezier') {
        if (dots.length < 2) return alert('至少 2 个点！')
        const points = Array.prototype.map.call(dots, dot => JSON.parse(dot.dataset.position))

        composite({
            position: curve.bezier({
                p1: {x: player.offsetLeft, y: player.offsetTop},
                p2: points[0],
                p3: points[1],
                duration: 1,
                ease: easing.easeInOut
            }),
            scale: tween({from: 1, to: 2}),
            color: tween({from: utils.hex2rgb(0xff33cc), to: utils.hex2rgb(0xffcc33)})
        }).start(v => {
            player.style.left = `${v.position.x}px`
            player.style.top = `${v.position.y}px`
            player.style.backgroundColor = utils.rgb2hex(v.color)
            player.style.transform = `translate(-50%, -50%) scale(${v.scale})`

            const dot = document.createElement('i')
            dot.classList.add('mini-dot')
            dot.style.left = player.style.left
            dot.style.top = player.style.top
            document.body.appendChild(dot)
        })

    } else if (action === 'cubicBezier') {
        if (dots.length < 3) return alert('至少 3 个点！')
        const points = Array.prototype.map.call(dots, dot => JSON.parse(dot.dataset.position))
        curve.cubicBezier({
            p1: {x: player.offsetLeft, y: player.offsetTop},
            p2: points[0],
            p3: points[1],
            p4: points[2],
            duration: 1,
            ease: easing.easeInOut
        }).start(trace)
    } else if (action === 'catmullRom') {
        if (dots.length < 1) return alert('至少 1 个点！')

        const points = Array.prototype.map.call(dots, dot => JSON.parse(dot.dataset.position))
        points.unshift({x: player.offsetLeft, y: player.offsetTop})
        curve.catmullRom(points, 10).start(trace)
    } else if (action === 'tween') {
        if (dots.length < 1) return alert('至少 1 个点！')

        const points = Array.prototype.map.call(dots, dot => JSON.parse(dot.dataset.position))

        tween({
            from: {x: player.offsetLeft, y: player.offsetTop, scale: 1},
            to: {...points[0], scale: 3},
            duration: 1,
            ease: easing.easeInOut
        }).start(trace)
    }
}

function trace(v) {
    player.style.left = `${v.x}px`
    player.style.top = `${v.y}px`
    player.style.transform = `translate(-50%, -50%) scale(${v.scale})`

    const dot = document.createElement('i')
    dot.classList.add('mini-dot')
    dot.style.left = player.style.left
    dot.style.top = player.style.top
    document.body.appendChild(dot)
}



function clear() {
    document.querySelectorAll('.dot').forEach(child => child.remove())
    document.querySelectorAll('.mini-dot').forEach(child => child.remove())
    player.setAttribute('style', '')
}

function distance(a, b) {
    return Math.sqrt((a.x - b.x) ** 2 + (a.y - b.y) ** 2)
}

function hex2string(hex) {
    hex = hex.toString(16)
    hex = '000000'.substr(0, 6 - hex.length) + hex
    return `#${hex}`
}