import {linear} from './easing'

export default function(option) {
    const {from, to, duration = 1, ease = linear} = option

    function start(option) {
        const complex = isNaN(from)

        let update, complete, id, delta, result,
            t = 0

        complex ? (delta = {}, result = {}, Object.keys(from).forEach(key => {
            delta[key] = to[key] - from[key]
        })) : delta = to - from

        if (option instanceof Function) update = option
        else ({update, complete} = option)

        !function loop() {
            t += 1 / 60 / duration
            t > 1 ? t = 1 : null
            if (complex) for (const key in delta) {
                result[key] = from[key] + delta[key] * ease(t)
            } else result = from + delta * ease(t)
            update(result)
            t === 1 ? complete && complete() : id = requestAnimationFrame(loop)
        }()

        return {
            stop() {
                cancelAnimationFrame(id)
            }
        }
    }

    return {start}
}