const
    path = require('path'),
    htmlWebpackPlugin = require('html-webpack-plugin'),
    webpack = require('webpack')

const isProd = process.env.NODE_ENV === 'production'


module.exports = {
    entry: [
        './src/index.less',
        './src/app.js'
    ],

    output: {
        path: path.resolve('dist'),
        filename: 'game.js'
    },

    devServer: {
        hot: true,
        contentBase: '.',
        stats: 'errors-only'
    },

    stats: 'errors-only',

    devtool: isProd ? false : 'source-map',

    module: {
        rules: [
            {
                test: /\.js$/,
                use: ['babel-loader'],
                exclude: /node_modules/
            },
            {
                test: /\.less$/,
                use: ['style-loader', 'css-loader', 'less-loader']
            }
        ]
    },

    plugins: [
        new htmlWebpackPlugin({
            template: './src/template.html',
            hash: true,
            filename: 'index.html',
            inject: 'body',
            minify: {
                collapseWhitespace: true
            }
        }),

        new webpack.NamedModulesPlugin(),
        new webpack.HotModuleReplacementPlugin()
    ],

    mode: isProd ? 'production' : 'development'
}