const
    path = require('path'),
    webpack = require('webpack')

module.exports = {
    entry: [
        './src/core/index.js'
    ],

    output: {
        path: path.resolve('dist'),
        filename: 'moto.min.js',
        libraryTarget: 'umd',
        library: 'moto'
    },

    stats: 'errors-only',

    devtool: false,

    module: {
        rules: [
            {
                test: /\.js$/,
                use: ['babel-loader'],
                exclude: /node_modules/
            }
        ]
    },

    mode: 'production'
}