export default function(points, v=10) {

    /* catmull rom 不会连接首尾点 */
    points.unshift(points[0])
    points.push(points[points.length - 1])

    function start(option) {
        let id, update, complete,
            t = 0

        if (option instanceof Function) update = option
        else ({update, complete} = option)


        function* generate() {
            for (let i = 0; i + 3 < points.length; i++) {
                yield {
                    p1: points[i],
                    p2: points[i + 1],
                    p3: points[i + 2],
                    p4: points[i + 3],
                    delta: v / distance(points[i + 1], points[i + 2])
                }
            }
        }

        const iterator = generate()
        let {p1, p2, p3, p4, delta} = iterator.next().value

        !function loop() {
            t += delta
            t > 1 ? t = 1 : null

            update(catmullRom(p1, p2, p3, p4, t))

            if (t === 1) {
                const {value, done} = iterator.next()
                if (done) complete && complete()
                else {
                    ({p1, p2, p3, p4, delta} = value)
                    t = 0
                    id = requestAnimationFrame(loop)
                }
            } else id = requestAnimationFrame(loop)
        }()

        return {
            stop() {
                cancelAnimationFrame(id)
            }
        }
    }

    return {start}
}

function distance(p1, p2) {
    return Math.sqrt((p1.x - p2.x) ** 2 + (p1.y - p2.y) ** 2)
}

function catmullRom(p1, p2, p3, p4, t) {
    return {
        x: calc(p1.x, p2.x, p3.x, p4.x, t),
        y: calc(p1.y, p2.y, p3.y, p4.y, t)
    }
}

function calc(p1, p2, p3, p4, t) {
    const
        a = [t ** 3, t ** 2, t, 1],
        b = [[-.5, 1.5, -1.5, .5], [1, -2.5, 2, -.5], [-.5, 0, .5, 0], [0, 1, 0, 0]],
        c = [p1, p2, p3, p4]

    return multiply(
        a.map((_, i) => multiply(a, b.map((_, j) => b[j][i]))),
        c
    )
}

function multiply(a, b) {
    return a.map((item, i) => item * b[i])
        .reduce((total, current) => total + current)
}