import {linear} from '../easing'

export default function(option) {
    const {p1, p2, p3, p4, duration = 1, ease = linear} = option

    function start(option) {
        let id, update, complete, t = 0

        if (option instanceof Function) update = option
        else ({update, complete} = option)

        !function loop() {
            t += 1 / 60 / duration
            t > 1 ? t = 1 : null
            update(bezier(p1, p2, p3, p4, ease(t)))
            t === 1 ? complete && complete() : id = requestAnimationFrame(loop)
        }()

        return {
            stop() {
                cancelAnimationFrame(id)
            }
        }
    }

    return {start}
}

function bezier(p1, p2, p3, p4, t) {
    return {
        x: calc(p1.x, p2.x, p3.x, p4.x, t),
        y: calc(p1.y, p2.y, p3.y, p4.y, t)
    }
}

function calc(p1, p2, p3, p4, t) {
    return (1 - t) ** 3 * p1 +
        3 * (1 - t) ** 2 * t * p2 +
        3 * (1 - t) * t ** 2 * p3 +
        t ** 3 * p4
}