package com.atguigu.tx;

import java.beans.PropertyVetoException;

import javax.sql.DataSource;

import org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator;
import org.springframework.aop.framework.autoproxy.InfrastructureAdvisorAutoProxyCreator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.ProxyTransactionManagementConfiguration;
import org.springframework.transaction.annotation.TransactionManagementConfigurationSelector;
import org.springframework.transaction.annotation.Transactional;

import com.mchange.v2.c3p0.ComboPooledDataSource;

/**
 * ʽ
 * 
 * 
 * 1
 * 		ԴݿSpring-jdbcģ
 * 2ԴJdbcTemplateSpringṩļݿĹߣ
 * 3ϱע @Transactional ʾǰһ񷽷
 * 4 @EnableTransactionManagement עܣ
 * 		@EnableXXX
 * 5;
 * 		@Bean
 * 		public PlatformTransactionManager transactionManager()
 * 
 * 
 * ԭ
 * 1@EnableTransactionManagement
 * 			TransactionManagementConfigurationSelectorлᵼ
 * 			
 * 			AutoProxyRegistrar
 * 			ProxyTransactionManagementConfiguration
 * 2AutoProxyRegistrar
 * 			עһ InfrastructureAdvisorAutoProxyCreator 
 * 			InfrastructureAdvisorAutoProxyCreator
 * 			úôڶ󴴽Ժ󣬰װ󣬷һǿִзеã
 * 
 * 3ProxyTransactionManagementConfiguration ʲô
 * 			1עǿ
 * 				1ǿҪעϢAnnotationTransactionAttributeSourceע
 * 				2
 * 					TransactionInterceptorϢ
 * 					һ MethodInterceptor
 * 					Ŀ귽ִеʱ
 * 						ִ
 * 						
 * 							1Ȼȡص
 * 							2ٻȡPlatformTransactionManagerûָκtransactionmanger
 * 								ջаͻȡһPlatformTransactionManager
 * 							3ִĿ귽
 * 								쳣ȡع
 * 								ύ
 * 			
 */
@EnableTransactionManagement
@ComponentScan("com.atguigu.tx")
@Configuration
public class TxConfig {
	
	//Դ
	@Bean
	public DataSource dataSource() throws Exception{
		ComboPooledDataSource dataSource = new ComboPooledDataSource();
		dataSource.setUser("dev");
		dataSource.setPassword("dev_fas015");
		dataSource.setDriverClass("com.mysql.jdbc.Driver");
		dataSource.setJdbcUrl("jdbc:mysql://dev.config.duibar.com:3306/test");
		return dataSource;
	}
	
	//
	@Bean
	public JdbcTemplate jdbcTemplate() throws Exception{
		//Spring@Configuration⴦мķεöֻǴ
		JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource());
		return jdbcTemplate;
	}
	
	//ע
	@Bean
	public PlatformTransactionManager transactionManager() throws Exception{
		return new DataSourceTransactionManager(dataSource());
	}
	

}
