package com.atguigu.config;

import com.atguigu.bean.Color;
import com.atguigu.bean.ColorFactoryBean;
import com.atguigu.bean.Person;
import com.atguigu.bean.Red;
import com.atguigu.condition.LinuxCondition;
import com.atguigu.condition.MyImportBeanDefinitionRegistrar;
import com.atguigu.condition.MyImportSelector;
import com.atguigu.condition.WindowsCondition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

//ͳһá㵱ǰõbeanעЧ
@Conditional({WindowsCondition.class})
@Configuration
@Import({Color.class,Red.class,MyImportSelector.class,MyImportBeanDefinitionRegistrar.class})
//@ImportidĬȫ
public class MainConfig2 {
	
	//Ĭǵʵ
	/**
	 * ConfigurableBeanFactory#SCOPE_PROTOTYPE    
	 * @see ConfigurableBeanFactory#SCOPE_SINGLETON  
	 * @see org.springframework.web.context.WebApplicationContext#SCOPE_REQUEST  request
	 * @see org.springframework.web.context.WebApplicationContext#SCOPE_SESSION	 sesssion
	 * @return\
	 * @Scope:
	 * prototypeʵģiocȥ÷С
	 * 					ÿλȡʱŻ÷
	 * singletonʵģĬֵioc÷ŵiocС
	 * 			ԺÿλȡֱӴmap.get()ã
	 * requestͬһ󴴽һʵ
	 * sessionͬһsessionһʵ
	 * 
	 * أ
	 * 		ʵbeanĬʱ򴴽
	 * 		أ󡣵һʹ(ȡ)Bean󣬲ʼ
	 * 
	 */
//	@Scope("prototype")
	@Lazy
	@Bean("person")
	public Person person(){
		System.out.println("Person....");
		return new Person("", 25);
	}
	
	/**
	 * @Conditional({Condition})  һжϣעbean
	 * 
	 * ϵͳwindowsע("bill")
	 * linuxϵͳע("linus")
	 */
	
	@Bean("bill")
	public Person person01(){
		return new Person("Bill Gates",62);
	}
	
	@Conditional(LinuxCondition.class)
	@Bean("linus")
	public Person person02(){
		return new Person("linus", 48);
	}
	
	/**
	 * ע
	 * 1ɨ+עע⣨@Controller/@Service/@Repository/@Component[Լд]
	 * 2@Bean[ĵ]
	 * 3@Import[ٸеһ]
	 * 		1@Import(Ҫ뵽е)оͻԶעidĬȫ
	 * 		2ImportSelector:Ҫȫ飻
	 * 		3ImportBeanDefinitionRegistrar:ֶעbean
	 * 4ʹSpringṩ FactoryBeanBean;
	 * 		1ĬϻȡǹbeangetObjectĶ
	 * 		2ҪȡBeanҪidǰһ&
	 * 			&colorFactoryBean
	 */
	@Bean
	public ColorFactoryBean colorFactoryBean(){
		return new ColorFactoryBean();
	}
	
	
	
	
	
	

}