package com.atguigu.condition;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

//жǷlinuxϵͳ
public class LinuxCondition implements Condition {

	/**
	 * ConditionContextжʹõģ
	 * AnnotatedTypeMetadataעϢ
	 */
	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		// TODOǷlinuxϵͳ
		//1ܻȡiocʹõbeanfactory
		ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
		//2ȡ
		ClassLoader classLoader = context.getClassLoader();
		//3ȡǰϢ
		Environment environment = context.getEnvironment();
		//4ȡbeanע
		BeanDefinitionRegistry registry = context.getRegistry();
		
		String property = environment.getProperty("os.name");
		
		//жеbeanעҲԸעbean
		boolean definition = registry.containsBeanDefinition("person");
		if(property.contains("linux")){
			return true;
		}
		
		return false;
	}

}
