package com.example.demo.threadDesignMode.threadObservable.threadObservabledemo;

import java.util.concurrent.TimeUnit;

/**
 * @author liukai
 * @Description: TODO
 * @date 2018/10/293:03 PM
 */
public class ObservableThread<T> extends Thread implements Observable{



    private final TaskLifecycle<T> lifecycle;

    private final Task<T> task;

    private Cycle cycle;



    public ObservableThread(TaskLifecycle<T> taskLifecycle,Task<T> task){

        super();

        if(task==null){
            throw new IllegalArgumentException("the task is required");
        }

        this.lifecycle = taskLifecycle;

        this.task =task;
    }


    @Override
    public final void run(){

        this.update(Cycle.STARTED,null,null);
        try {
            this.update(Cycle.RUNNING,null,null);
            T result = this.task.call();
            this.update(Cycle.DONE,result,null);
        } catch (Exception e) {
            this.update(Cycle.ERROR,null,e);
        }


    }



        private void update(Cycle cycle,T result,Exception e){
            this.cycle = cycle;
            if(lifecycle==null){
                return ;

            }
            try {
                switch (cycle){
                    case DONE:
                        this.lifecycle.onFinish(currentThread(),result);
                    case ERROR:
                        this.lifecycle.onError(currentThread(),e);
                    case RUNNING:
                        this.lifecycle.onRunning(currentThread());
                    case STARTED:
                        this.lifecycle.onStart(currentThread());
                }
            } catch (Exception e1) {
               if(cycle ==Cycle.ERROR){
                   throw e1;
               }
            }

        }


    @Override
    public Cycle getCycle() {
        return this.cycle;
    }


    public static void main(String[] args) {

        final TaskLifecycle<String> lifecycle = new TaskLifecycle.EmptyLifecycle<String>(){

            @Override
            public void onFinish(Thread thread, String result) {
                System.out.println("the result is "+ result);
            }
        };


        Observable observableThread = new ObservableThread<String>(lifecycle,()->{

            try {
                TimeUnit.SECONDS.sleep(10);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("finish done");
            return "Hello 1";
        });


        observableThread.start();


    }
}
