/**
 * Created by rockyl on 2019-11-17.
 */

const {prepare, compile} = require('./tscompiler');
const fs = require('fs-extra');
const path = require('path');
const glob = require('glob');

const tsconfig = fs.readJsonSync('tsconfig.json');

prepare(tsconfig, process.cwd());

function compileProcess(sourcePath, output, isBuiltin) {
	const arr = sourcePath.split('/');
	const group = arr[0];
	const id = arr[1];
	const meta = fs.readJsonSync(path.join('src/' + sourcePath, 'meta.json'));
	const {code} = compile('src/' + sourcePath);
	meta.id = id;
	meta.script = code;
	meta.group = group;
	if(isBuiltin){
		meta.type = 'builtin'
	}

	const outputPath = path.join(output, sourcePath + '.json');
	fs.ensureDirSync(path.dirname(outputPath));
	fs.writeJsonSync(outputPath, meta, {spaces: '  '});

	console.log(`compile process [${sourcePath}] successfully!`);
}

const [_, __, sourcePath, outputPath = 'dist', builtin] = process.argv;

const isBuiltin = builtin ? builtin === 'builtin' : true;
if (sourcePath) {
	compileProcess(sourcePath, outputPath, isBuiltin);
} else {
	const files = glob.sync('*/*', {cwd: process.cwd() + '/src'});
	for (let file of files) {
		compileProcess(file, outputPath, isBuiltin);
	}
}

console.log('complete!');
