(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('typescript'), require('uglify-js'), require('zeroing-code-divider'), require('zeroing-template-fill')) :
	typeof define === 'function' && define.amd ? define(['exports', 'typescript', 'uglify-js', 'zeroing-code-divider', 'zeroing-template-fill'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global['zeroing-pack'] = {}, global.ts, global.UglifyJS, global.zeroingCodeDivider, global.zeroingTemplateFill));
}(this, (function (exports, ts, UglifyJS, zeroingCodeDivider, zeroingTemplateFill) { 'use strict';

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var ts__default = /*#__PURE__*/_interopDefaultLegacy(ts);
	var UglifyJS__default = /*#__PURE__*/_interopDefaultLegacy(UglifyJS);

	/**
	 * Created by rockyl on 2019-11-30.
	 */

	async function compile(source, debug = false) {
		let output = ts__default['default'].transpileModule(source, {
			compilerOptions: {}
		});

		const result = {
			code: output.outputText,
		};
		/*if (map) {
			result.sourcemap = map.mappings;
		}*/
		return result;
	}

	function uglify(source) {
		const uglifyResult = UglifyJS__default['default'].minify(source, {});
		if (uglifyResult.error) {
			throw new Error(uglifyResult.error);
		} else {
			return uglifyResult.code;
		}
	}

	/**
	 * Created by rockyl on 2019-11-13.
	 *
	 * 项目打包
	 */

	const replaceFields = ['pageTitle', 'containerId'];
	const TAG = 'zeroing-pack';

	async function pack(data, options) {
		let dependencies = data.dependencies;
		let getPackages = options.getPackages;

		const {libraryScriptElMap, analyseResult} = await zeroingTemplateFill.generateLibraryScriptEl(data.options.tpl, dependencies, getPackages, '//yun.duiba.com.cn/editor/zeroing/libs/', options.debug);

		let version = Date.now() + Math.floor(Math.random() * 1000);
		pageTemplate(data, data.options, version, analyseResult, libraryScriptElMap);
		const newData = await packData(data, options);

		return {
			version,
			data: newData,
		}
	}

	function fillTpl(data, params, mix) {
		const {options} = data;
		if (mix) {
			let code = 'var adsComplete=false;ga.showBanner(function(){adsComplete=true},' + params.scripts.map(item => `'${item}'`).join(',') + ');';
			params.scripts = zeroingTemplateFill.generateJsScriptBodyEl(code);
		} else {
			params.scripts = params.scripts.map(item => zeroingTemplateFill.generateJsScriptEl(item)).join('\n');
		}
		let tpl = zeroingTemplateFill.fillTemplate(options.newTpl, params);

		delete options.newTpl;
		delete options.tpl;
		delete options.projectxConfig;
		delete options.pxEnv;

		return tpl;
	}

	async function packData(data, {debug, mix, packedAssets, getPackages}) {
		let newData = {};
		newData.options = data.options;
		newData.views = data.views;
		newData.assets = packedAssets || data.assets;
		newData.dataMapping = data.dataMapping;
		newData.processes = data.processes;
		newData.customs = data.customs;

		deleteUnusedData(newData.processes);

		console.log(TAG, 'start');

		for (let view of newData.views) {
			if (view.store) {
				let {exp, computed} = view.store;
				if (exp) {
					view.store.exp = (await compile(exp)).code;
				}
				if (computed) {
					for (let item of computed) {
						if (item.script) {
							item.script = (await compile(item.script)).code;
						}
					}
				}
			}
		}

		const {
			processScriptContent,
			scriptsContent,
			customScriptContent,
		} = await zeroingCodeDivider.divideCode(newData, {
			debug,
			mix,
			uglify, compile,
			getPackages,
			dependencies: data.dependencies,
		});

		return {
			data: newData,
			processScriptContent,
			scriptsContent,
			customScriptContent,
		};
	}

	const unusedFields = ['design'];

	function deleteUnusedData(processes) {
		for (let process of processes) {
			if (process.sub) {
				for (let uuid in process.sub) {
					let subProcess = process.sub[uuid];
					for (let field of unusedFields) {
						if (subProcess.hasOwnProperty(field)) {
							delete subProcess[field];
						}
					}
				}
			}
			if (process.metas && process.metas.length > 0) {
				deleteUnusedData(process.metas);
			}
		}
	}

	function pageTemplate(tpl, options, version, analyseResult, libraryScriptElMap) {
		const params = {
			version,
			libraries: libraryScriptElMap,
		};
		for (let field of replaceFields) {
			params[field] = options[field];
		}

		options.newTpl = zeroingTemplateFill.fillTemplate(options.tpl, params, analyseResult);
	}

	exports.fillTpl = fillTpl;
	exports.pack = pack;

	Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=index.umd.js.map
