/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目打包
 */

import decamelize from 'decamelize'
import ProcessManager from './ProcessManager'
import ScriptManager from './ScriptManager'
import CustomManager from './CustomManager'
import {uglify} from "./code-process";

const replaceFields = ['pageTitle', 'containerId'];
const TAG = 'zeroing-pack';

export async function pack(data, options) {
	let version = Date.now() + Math.floor(Math.random() * 1000);
	pageTemplate(data, data.options, version);
	const newData = await packData(data, options);

	return {
		version,
		data: newData,
	}
}

export function fillTpl(data, params) {
	const {options} = data;
	fillTemplate(options.newTpl, options, params);

	return options.newTpl;
}

async function packData(data, {debug, getProcesses, getScripts, getCustoms}) {
	const processManager = new ProcessManager();
	const scriptManager = new ScriptManager();
	const customManager = new CustomManager();

	let newData = {};
	newData.options = data.options;
	delete newData.options.tpl;
	newData.views = data.views;
	newData.assets = data.assets;
	newData.dataMapping = data.dataMapping;
	newData.processes = data.processes;

	console.log(TAG, 'start');

	/*=====START process =====*/
	console.log(TAG, 'start process');
	let processIDs = [];
	findDepPidsBat(processIDs, data.processes);
	let builtinProcesses = newData.builtinProcesses = [];

	let bProcessIDs = processIDs;
	while (true) {
		let newPids = await addBuiltinProcesses(builtinProcesses, bProcessIDs, getProcesses);
		bProcessIDs = [];
		for (let id of newPids) {
			if (!processIDs.includes(id)) {
				bProcessIDs.push(id);
				processIDs.push(id);
			}
		}
		if (bProcessIDs.length === 0) {
			break;
		}
	}

	for (let process of data.processes) {
		processManager.deal(process);
	}

	console.log(TAG, 'processManager.generateCurrent()');
	await processManager.generateCurrent(); //自定义过程先编译

	for (let process of builtinProcesses) {
		processManager.deal(process);
	}

	let processScriptContent = processManager.generate();
	//console.log(processScriptContent);
	if (!debug) {
		processScriptContent = uglify(processScriptContent);
	}
	/*=====END process =====*/

	/*=====START script =====*/
	console.log(TAG, 'start script');
	let scriptIDs = [];
	for (let view of newData.views) {
		traverseNode(view, (node) => {
			if (node.scripts && node.scripts.length > 0) {
				for (let {script} of node.scripts) {
					if (!scriptIDs.includes(script)) {
						scriptIDs.push(script);
					}
				}
			}
		});
	}
	//console.log('scriptIDs:', scriptIDs);
	//let scriptsContainer = newData.scripts = {};
	//let scriptsCode = '';
	if (scriptIDs.length > 0) {
		const scripts = await getScripts(scriptIDs);
		for (let scriptData of scripts) {
			let script = JSON.parse(scriptData);
			//scriptsContainer[id] = code;
			scriptManager.deal(script);
		}
		//console.log('scripts:', scriptsContainer);
	}

	let scriptsContent = scriptManager.generate();
	//console.log(scriptsContent);
	if (!debug) {
		scriptsContent = uglify(scriptsContent);
	}
	/*=====END script =====*/

	/*=====START custom =====*/
	console.log(TAG, 'start custom');
	//newData.customs = [];
	if (data.customs && data.customs.length > 0) {
		/*newData.customs = */
		(await getCustoms(data.customs)).map(item => {
			customManager.deal(JSON.parse(item));
			//return JSON.parse(item);
		})
	}
	let customScriptContent = customManager.generate();
	//console.log(customScriptContent);
	if (!debug) {
		customScriptContent = uglify(customScriptContent);
	}
	/*=====END custom =====*/

	return {
		data: JSON.stringify(newData),
		processScriptContent,
		scriptsContent,
		customScriptContent,
	};
}

function findDepPids(list, process) {
	if (process.sub) {
		for (let key in process.sub) {
			let p = process.sub[key];
			if (!list.includes(p.meta)) {
				list.push(p.meta);
			}
		}
	}
}

function findDepPidsBat(list, processes) {
	for (let process of processes) {
		findDepPids(list, process);
	}
}

async function addBuiltinProcesses(list, ids, getProcesses) {
	let newPids = [];
	if (ids.length > 0) {
		let processes = await getProcesses(ids);
		for (let processData of processes) {
			let process = JSON.parse(processData);
			list.push(process);
			findDepPids(newPids, process);
		}
		//console.log('processes:', data.processes);
	}
	return newPids;
}

function pageTemplate(tpl, options, version) {
	const params = {
		version,
	};
	for (let field of replaceFields) {
		params[field] = options[field];
	}
	fillTemplate(options.tpl, options, params);
}

function fillTemplate(tpl, options, params) {
	for (let field in params) {
		const pattern = decamelize(field).toUpperCase();
		tpl = tpl.replace(new RegExp(`\\$${pattern}\\$`, 'g'), params[field]);
	}

	options.newTpl = tpl;
}

function traverseNode(root, callback) {
	callback(root);
	if (root.children && root.children.length > 0) {
		for (let childNode of root.children) {
			traverseNode(childNode, callback);
		}
	}
}
