'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目打包
 */

const camelcase = require('camelcase');

const replaceFields = ['page_title', 'container_id', 'version'];

async function pack(project, options) {
	let version = Date.now() + Math.floor(Math.random() * 1000);
	let data = JSON.parse(project.data);
	const newTpl = await pageTemplate(data, options, version);
	const newData = await packData(data, options);

	return {
		version,
		data: newData,
		tpl: newTpl,
	}
}

async function packData(data, {getProcesses, getScripts, getCustoms}) {
	let newData = {};
	newData.options = data.options;
	delete newData.options.tpl;
	newData.views = data.views;
	newData.assets = data.assets;
	newData.dataMapping = data.dataMapping;
	newData.processes = data.processes;

	let scriptIDs = [];
	for (let view of newData.views) {
		traverseNode(view, (node) => {
			if (node.scripts && node.scripts.length > 0) {
				for (let {script} of node.scripts) {
					if (!scriptIDs.includes(script)) {
						scriptIDs.push(script);
					}
				}
			}
		});
	}
	//console.log('scriptIDs:', scriptIDs);
	let scriptsContainer = newData.scripts = {};
	if (scriptIDs.length > 0) {
		const scripts = await getScripts(scriptIDs);
		for (let scriptData of scripts) {
			let {id, code} = JSON.parse(scriptData);
			scriptsContainer[id] = code;
		}
		//console.log('scripts:', scriptsContainer);
	}

	let processIDs = [];
	findDepPidsBat(processIDs, newData.processes);
	//console.log('processIDs:', processIDs);
	let builtinProcesses = newData.builtinProcesses = [];

	let bProcessIDs = processIDs;
	while (true) {
		let newPids = await addBuiltinProcesses(builtinProcesses, bProcessIDs, getProcesses);
		bProcessIDs = [];
		for (let id of newPids) {
			if (!processIDs.includes(id)) {
				bProcessIDs.push(id);
				processIDs.push(id);
			}
		}
		if (bProcessIDs.length === 0) {
			break;
		}
	}

	newData.customs = [];
	if (data.customs && data.customs.length > 0) {
		newData.customs = await getCustoms(data.customs).map(item => {
			return JSON.parse(item);
		});
	}

	return JSON.stringify(newData);
}

function findDepPids(list, process) {
	if (process.sub) {
		for (let key in process.sub) {
			let p = process.sub[key];
			if (!list.includes(p.meta)) {
				list.push(p.meta);
			}
		}
	}
}

function findDepPidsBat(list, processes) {
	for (let process of processes) {
		findDepPids(list, process);
	}
}

async function addBuiltinProcesses(list, ids, getProcesses) {
	let newPids = [];
	if (ids.length > 0) {
		let processes = await getProcesses(ids);
		for (let processData of processes) {
			let process = JSON.parse(processData);
			list.push(process);
			findDepPids(newPids, process);
		}
		//console.log('processes:', data.processes);
	}
	return newPids;
}

async function pageTemplate(data, options, version) {
	const {tpl,} = data.options;
	let newTpl = tpl;
	let newOptions = Object.assign(data.options, {
		version,
	});
	delete newOptions.tpl;
	for (let field of replaceFields) {
		const key = camelcase(field);
		newTpl = newTpl.replace(new RegExp(`\\$${field.toUpperCase()}\\$`, 'g'), newOptions[key]);
	}
	return newTpl;
}

function traverseNode(root, callback) {
	callback(root);
	if (root.children && root.children.length > 0) {
		for (let childNode of root.children) {
			traverseNode(childNode, callback);
		}
	}
}

exports.pack = pack;
//# sourceMappingURL=index.js.map
