/**
 * Created by rockyl on 2019-11-30.
 */

import babel from '@babel/core';

const UglifyJS = require('uglify-js');

export async function compile(source, debug = false) {
	const {code, map} = await babel.transformAsync(source, {
		presets: [
			['@babel/env', {}]
		],
		babelrc: false,
		sourceMaps: debug,
	});

	const result = {
		code,
	};
	if (map) {
		result.sourcemap = map.mappings;
	}
	return result;
}

export function uglify(source){
	const uglifyResult = UglifyJS.minify(source, {
	});
	if (!uglifyResult.error) {
		return uglifyResult.code;
	}
}