/**
 * Created by rockyl on 2019-11-29.
 */

import crypto from 'crypto'
import {compile} from "./code-process";

function md5(source) {
	const hash = crypto.createHash('md5');
	return hash.update(source).digest('hex');
}

export default class ProcessManager {
	constructor() {
		this.pool = {};
		this.scripts = '';
	}

	deal(process) {
		let hash = this.put(process);
		if (hash) {
			process.script = 'link://' + hash;
		}
		if (process.metas) {
			for (let subProcess of process.metas) {
				this.deal(subProcess);
			}
		}
	}

	put(process) {
		const {id, name, script} = process;
		if (script) {
			let hash = md5(script);
			if (!this.pool.hasOwnProperty(hash)) {
				this.pool[hash] = {
					script,
					ids: [],
				};
			}
			this.pool[hash].ids.push(`${id} - ${name}`);
			return hash;
		}
	}

	generateCurrent() {
		let scripts = '';
		for (let hash in this.pool) {
			let {script, ids} = this.pool[hash];
			let idsComment = ids.map(id => {
				return `/*== ${id} ==*/`
			}).join('\n');
			scripts += `
	exports['${hash}'] = function(args, props, target, global, vm){
		return new Promise(function(resolve, reject){

${idsComment}
${script}

		function next(type, payload){resolve({type: type, payload: payload})}
		});
	};
`;
		}
		this.scripts += scripts;
		this.pool = {};
	}

	async compile() {
		try {
			const {code, sourcemap} = await compile(this.scripts, true);
			this.scripts = code;
		} catch (e) {
			console.log('编译失败', e);
		}
	}

	generate() {
		this.generateCurrent();
		let scripts = this.scripts;

		return `
(function(){
var exports = {};
${scripts}

	engine.setScriptMap(exports);
})();
`
	}
}
