/**
 * Created by rockyl on 2019-11-30.
 */

import ts from 'typescript';
import UglifyJS from 'uglify-js';

export async function compile(source, debug = false) {
	let output = ts.transpileModule(source, {
		compilerOptions: {}
	});

	const result = {
		code: output.outputText,
	};
	/*if (map) {
		result.sourcemap = map.mappings;
	}*/
	return result;
}

export function uglify(source) {
	const uglifyResult = UglifyJS.minify(source, {});
	if (uglifyResult.error) {
		throw new Error(uglifyResult.error);
	} else {
		return uglifyResult.code;
	}
}