/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目打包
 */

import {uglify, compile} from "./code-process";
import {divideCode} from 'zeroing-code-divider';
import {generateLibraryScriptEl, fillTemplate, generateJsScriptEl} from 'zeroing-template-fill';

const replaceFields = ['pageTitle', 'containerId'];
const TAG = 'zeroing-pack';

export async function pack(data, options) {
	let dependencies = data.dependencies;
	let getPackages = options.getPackages;

	const {libraryScriptElMap, analyseResult} = await generateLibraryScriptEl(data.options.tpl, dependencies, getPackages, '//yun.duiba.com.cn/editor/zeroing/libs/', options.debug);

	let version = Date.now() + Math.floor(Math.random() * 1000);
	pageTemplate(data, data.options, version, analyseResult, libraryScriptElMap);
	const newData = await packData(data, options);

	return {
		version,
		data: newData,
	}
}

export function fillTpl(data, params) {
	const {options} = data;
	params.scripts = params.scripts.map(item => generateJsScriptEl(item)).join('\n');
	let tpl = fillTemplate(options.newTpl, params);

	delete options.newTpl;
	delete options.tpl;
	delete options.projectxConfig;
	delete options.pxEnv;

	return tpl;
}

async function packData(data, {debug, packedAssets, getPackages}) {
	let newData = {};
	newData.options = data.options;
	newData.views = data.views;
	newData.assets = packedAssets || data.assets;
	newData.dataMapping = data.dataMapping;
	newData.processes = data.processes;
	newData.customs = data.customs;

	deleteUnusedData(newData.processes);

	console.log(TAG, 'start');

	for (let view of newData.views) {
		if (view.store) {
			let {exp, computed} = view.store;
			if (exp) {
				view.store.exp = (await compile(exp)).code;
			}
			if (computed) {
				for (let item of computed) {
					if (item.script) {
						item.script =  (await compile(item.script)).code;
					}
				}
			}
		}
	}

	const {
		processScriptContent,
		scriptsContent,
		customScriptContent,
	} = await divideCode(newData, {
		debug,
		uglify, compile,
		getPackages,
		dependencies: data.dependencies,
	});

	return {
		data: newData,
		processScriptContent,
		scriptsContent,
		customScriptContent,
	};
}

const unusedFields = ['design'];

function deleteUnusedData(processes) {
	for (let process of processes) {
		if (process.sub) {
			for (let uuid in process.sub) {
				let subProcess = process.sub[uuid];
				for (let field of unusedFields) {
					if (subProcess.hasOwnProperty(field)) {
						delete subProcess[field];
					}
				}
			}
		}
		if (process.metas && process.metas.length > 0) {
			deleteUnusedData(process.metas);
		}
	}
}

function pageTemplate(tpl, options, version, analyseResult, libraryScriptElMap) {
	const params = {
		version,
		libraries: libraryScriptElMap,
	};
	for (let field of replaceFields) {
		params[field] = options[field];
	}

	options.newTpl = fillTemplate(options.tpl, params, analyseResult);
}
